<?php
/**
 * @package     Joomla.UnitTest
 * @subpackage  com_finder
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

require_once JPATH_ADMINISTRATOR . '/components/com_finder/helpers/indexer/result.php';

/**
 * Test class for FinderIndexerResult.
 * Generated by PHPUnit on 2012-06-10 at 14:51:47.
 */
class FinderIndexerResultTest extends TestCaseDatabase
{
	/**
	 * @var FinderIndexerResult
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		parent::setUp();

		// Instantiate the object
		$this->object = new FinderIndexerResult;
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @return void
	 *
	 * @see     \PHPUnit\Framework\TestCase::tearDown()
	 * @since   3.6
	 */
	protected function tearDown()
	{
		unset($this->object);
		parent::tearDown();
	}

	/**
	 * Gets the data set to be loaded into the database during setup
	 *
	 * @return  PHPUnit_Extensions_Database_DataSet_CsvDataSet
	 *
	 * @since   3.1
	 */
	protected function getDataSet()
	{
		$dataSet = new PHPUnit_Extensions_Database_DataSet_CsvDataSet(',', "'", '\\');

		$dataSet->addTable('jos_extensions', JPATH_TEST_DATABASE . '/jos_extensions.csv');

		return $dataSet;
	}

	/**
	 * Tests the magic get and set methods
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::__get
	 * @covers  FinderIndexerResult::__set
	 */
	public function test__getAndSet()
	{
		$this->object->testItem = 'success';

		$this->assertEquals(
			$this->object->testItem,
			'success'
		);
	}

	/**
	 * Tests the magic get method for a null return
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::__get
	 */
	public function test__getNull()
	{
		$this->assertEquals(
			$this->object->getSomething,
			null
		);
	}

	/**
	 * Tests the magic isset and unset methods
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::__isset
	 * @covers  FinderIndexerResult::__unset
	 */
	public function testMagicSetters()
	{
		// Set our test object
		$this->object->testItem = 'success';

		// Assert it is present
		$this->assertTrue(isset($this->object->testItem));

		// Unset our test project
		unset($this->object->testItem);

		// Assert our test object is gone
		$this->assertEquals(
			$this->object->testItem,
			null
		);
	}

	/**
	 * Tests the getElement method for a null return
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::getElement
	 */
	public function testGetElementNull()
	{
		$this->assertEquals(
			$this->object->getElement('getSomething'),
			null
		);
	}

	/**
	 * Tests the getElement and setElement methods
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::getElement
	 * @covers  FinderIndexerResult::setElement
	 */
	public function testGetAndSetElement()
	{
		$this->object->setElement('testItem', 'success');

		$this->assertEquals(
			$this->object->getElement('testItem'),
			'success'
		);
	}

	/**
	 * Method to test adding an instruction, retrieving the instructions array, and removing it
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::addInstruction
	 * @covers  FinderIndexerResult::getInstructions
	 * @covers  FinderIndexerResult::removeInstruction
	 */
	public function testManipulateInstructions()
	{
		// Add our test instruction
		$this->object->addInstruction(FinderIndexer::MISC_CONTEXT, 'testItem');

		$instructions = $this->object->getInstructions();
		$testItem = $instructions[FinderIndexer::MISC_CONTEXT];

		// Assert the test instruction is present
		$this->assertContains(
			'testItem',
			$testItem
		);

		// Remove the test instruction
		$this->object->removeInstruction(FinderIndexer::MISC_CONTEXT, 'testItem');

		$instructions = $this->object->getInstructions();
		$testItem = $instructions[FinderIndexer::MISC_CONTEXT];

		// Assert the test instruction is gone
		$this->assertNotContains(
			'testItem',
			$testItem
		);
	}

	/**
	 * Tests the getTaxonomy method for returning the full taxonomy array
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::getTaxonomy
	 */
	public function testGetTaxonomy()
	{
		$this->assertInternalType(
			'array',
			$this->object->getTaxonomy()
		);
	}

	/**
	 * Tests the addTaxonomy and getTaxonomy methods
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::addTaxonomy
	 */
	public function testTaxonomy()
	{
		// Add the test item to the taxonomy
		$this->object->addTaxonomy('testing', 'Test Item');

		// Retrieve our testing branch
		$taxonomy = $this->object->getTaxonomy('testing');

		// Verify our test item is an instance of JObject
		$this->assertInstanceOf(
			'JObject',
			$taxonomy['Test Item']
		);
	}

	/**
	 * Tests the setLanguage method
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerResult::setLanguage
	 */
	public function testSetLanguage()
	{
		// Test for an empty language
		$this->object->language = '';
		$this->object->setLanguage();

		$this->assertEquals(
			$this->object->language,
			$this->object->defaultLanguage
		);

		// Test for "all" language
		$this->object->language = '*';
		$this->object->setLanguage();

		$this->assertEquals(
			$this->object->language,
			'*'
		);

		// Test for "it-IT" language
		$this->object->language = 'it-IT';
		$this->object->setLanguage();

		$this->assertEquals(
			$this->object->language,
			'it-IT'
		);
	}
}
