# Copyright 1999-2023 Gentoo Authors
# Copyright 2020-2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_NAME="tdebase"
TRINITY_MODULE_TYPE="core"
inherit trinity-meta-2

DESCRIPTION="The Trinity application starter panel, capable of applets and extensions"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="xcomposite hwlib"

DEPEND="~trinity-base/libkonq-${PV}
	~trinity-base/tdebase-data-${PV}
	~dev-libs/dbus-tqt-${PV}
	xcomposite? ( x11-libs/libXrender
		x11-libs/libXfixes
		x11-libs/libXcomposite )"

RDEPEND="${DEPEND}
	~trinity-base/kmenuedit-${PV}"

src_prepare() {
	eapply "${FILESDIR}/tdebase-strlcpy.patch"
	trinity-meta-2_src_prepare
}

src_configure() {
	local mycmakeargs=(
		-DWITH_XFIXES="$(usex xcomposite)"
		-DWITH_XRENDER="$(usex xcomposite)"
		-DWITH_XCOMPOSITE="$(usex xcomposite)"
		-DWITH_TDEHWLIB="$(usex hwlib)"
	)

	trinity-meta-2_src_configure
}
