# Copyright 2023-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="optional"

TRINITY_LANGS="af ar be bg br bs ca csb cs cy da de el es et \
		fi fr ga gl he hi hu it ja ka lt mk nb nl pa \
		pt_BR pt ru rw sk sr sv ta th tr uk xh zh_CN \
		zh_TW zu"

TRINITY_DOC_LANGS="da de es et fr it nl pt ru sv"

TRINITY_MODULE_TYPE="applications/multimedia"
inherit trinity-base-2

DESCRIPTION="MPlayer - a simple media player for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="gstreamer koffice xine"

DEPEND="media-video/ffmpeg
	media-video/mplayer
	koffice? ( ~trinity-apps/koffice-meta-${PV} )
	gstreamer? ( media-plugins/gst-plugins-meta )
	xine? ( media-libs/xine-lib )"
RDEPEND="${DEPEND}"

src_configure() {
	local mycmakeargs=(
		-DBUILD_TRANSLATIONS=ON
		-DBUILD_KOFFICE_PLUGIN="$(usex koffice)"
		-DBUILD_KXVPLAYER="$(usex gstreamer)"
		-DBUILD_KXINEPLAYER="$(usex xine)"
	)
	trinity-base-2_src_configure
}
