--- tqt/secqstring.cpp.orig
+++ tqt/secqstring.cpp
@@ -80,8 +80,8 @@
 // IMPORTANT! If you change these, make sure you also change the
 // "delete unicode" statement in ~SecTQStringData() in SecTQString.h correspondingly!
 
-#define QT_ALLOC_SECTQCHAR_VEC(N) (TQChar*) ::secmem_malloc (sizeof(TQChar) * (N))
-#define QT_DELETE_SECTQCHAR_VEC(P) ::secmem_free (P)
+#define TQT_ALLOC_SECTQCHAR_VEC(N) (TQChar*) ::secmem_malloc (sizeof(TQChar) * (N))
+#define TQT_DELETE_SECTQCHAR_VEC(P) ::secmem_free (P)
 
 
 /*****************************************************************************
@@ -188,13 +188,13 @@
     \sa TQChar TQCString TQByteArray SecTQConstString
 */
 
-Q_EXPORT SecTQStringData *SecTQString::shared_null = 0;
-QT_STATIC_CONST_IMPL SecTQString SecTQString::null;
-QT_STATIC_CONST_IMPL TQChar TQChar::null;
-QT_STATIC_CONST_IMPL TQChar TQChar::replacement((ushort)0xfffd);
-QT_STATIC_CONST_IMPL TQChar TQChar::byteOrderMark((ushort)0xfeff);
-QT_STATIC_CONST_IMPL TQChar TQChar::byteOrderSwapped((ushort)0xfffe);
-QT_STATIC_CONST_IMPL TQChar TQChar::nbsp((ushort)0x00a0);
+TQ_EXPORT SecTQStringData *SecTQString::shared_null = 0;
+const SecTQString SecTQString::null;
+const TQChar TQChar::null;
+const TQChar TQChar::replacement((ushort)0xfffd);
+const TQChar TQChar::byteOrderMark((ushort)0xfeff);
+const TQChar TQChar::byteOrderSwapped((ushort)0xfffe);
+const TQChar TQChar::nbsp((ushort)0x00a0);
 
 SecTQStringData* SecTQString::makeSharedNull()
 {
@@ -220,7 +220,7 @@
 */
 SecTQString::SecTQString( TQChar ch )
 {
-    d = new SecTQStringData( QT_ALLOC_SECTQCHAR_VEC( 1 ), 1, 1 );
+    d = new SecTQStringData( TQT_ALLOC_SECTQCHAR_VEC( 1 ), 1, 1 );
     d->unicode[0] = ch;
 }
 
@@ -239,7 +239,7 @@
 {
     if ( size ) {
 	int l = size;
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( l );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( l );
 	d = new SecTQStringData( uc, 0, l );
     } else {
 	d = shared_null ? shared_null : (shared_null=new SecTQStringData);
@@ -258,7 +258,7 @@
 	d = shared_null ? shared_null : makeSharedNull();
 	d->ref();
     } else {
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( length );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( length );
 	if ( unicode )
 	    memcpy(uc, unicode, length*sizeof(TQChar));
 	d = new SecTQStringData(uc,unicode ? length : 0,length);
@@ -287,7 +287,7 @@
 	d = shared_null ? shared_null : makeSharedNull();
 	d->ref();
     } else {
-	TQChar* uc = QT_ALLOC_SECTQCHAR_VEC( length );
+	TQChar* uc = TQT_ALLOC_SECTQCHAR_VEC( length );
 	if ( unicode )
 	    memcpy(uc, unicode, length*sizeof(TQChar));
 	d = new SecTQStringData(uc,unicode ? length : 0,length);
@@ -429,7 +429,7 @@
 	 ( newLen * 4 < d->maxl && d->maxl > 4 ) ) {
 	// detach, grow or shrink
 	uint newMax = computeNewMax( newLen );
-	TQChar* nd = QT_ALLOC_SECTQCHAR_VEC( newMax );
+	TQChar* nd = TQT_ALLOC_SECTQCHAR_VEC( newMax );
 	if ( nd ) {
 	    uint len = TQMIN( d->len, newLen );
 	    memcpy( nd, d->unicode, sizeof(TQChar) * len );
@@ -548,7 +548,7 @@
 	    len = slen - index;
 	if ( index == 0 && len == slen )
 	    return *this;
-	register const TQChar *p = unicode()+index;
+	const TQChar *p = unicode()+index;
 	SecTQString s( len, TRUE );
 	memcpy( s.d->unicode, p, len * sizeof(TQChar) );
 	s.d->len = len;
@@ -594,10 +594,10 @@
 
     if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
 	// Part of me - take a copy.
-	TQChar *tmp = QT_ALLOC_SECTQCHAR_VEC( len );
+	TQChar *tmp = TQT_ALLOC_SECTQCHAR_VEC( len );
 	memcpy(tmp,s,len*sizeof(TQChar));
 	insert(index,tmp,len);
-	QT_DELETE_SECTQCHAR_VEC( tmp );
+	TQT_DELETE_SECTQCHAR_VEC( tmp );
 	return *this;
     }
 
@@ -669,10 +669,10 @@
 	memcpy( d->unicode+index, s, len * sizeof(TQChar) );
     } else if ( s >= d->unicode && (uint)(s - d->unicode) < d->maxl ) {
 	// Part of me - take a copy.
-	TQChar *tmp = QT_ALLOC_SECTQCHAR_VEC( slen );
+	TQChar *tmp = TQT_ALLOC_SECTQCHAR_VEC( slen );
 	memcpy( tmp, s, slen * sizeof(TQChar) );
 	replace( index, len, tmp, slen );
-	QT_DELETE_SECTQCHAR_VEC( tmp );
+	TQT_DELETE_SECTQCHAR_VEC( tmp );
     } else {
 	remove( index, len );
 	insert( index, s, slen );
