#include"qca.h"
#include<stdio.h>

static TQCString arrayToCString(const TQByteArray &);
static TQByteArray cstringToArray(const TQCString &);
static void doDynTest(TQCA::Cipher *c, const TQString &name, const TQCString &cs);

int main(int argc, char **argv)
{
	TQCA::init();
	TQCString cs = (argc >= 2) ? argv[1] : "hello";

	// AES128 test
	if(!TQCA::isSupported(TQCA::CAP_AES128))
		printf("AES128 not supported!\n");
	else {
		// encrypt
		TQByteArray key = TQCA::AES128::generateKey();
		TQByteArray iv = TQCA::AES128::generateIV();
		printf("aes128:key:%s\n", TQCA::arrayToHex(key).latin1());
		printf("aes128:iv:%s\n", TQCA::arrayToHex(iv).latin1());
		TQCA::AES128 c(TQCA::Encrypt, TQCA::CBC, key, iv);
		c.update(cstringToArray(cs));
		TQByteArray f = c.final();
		TQString result = TQCA::arrayToHex(f);
		printf(">aes128(\"%s\") = [%s]\n", cs.data(), result.latin1());

		// decrypt
		TQCA::AES128 d(TQCA::Decrypt, TQCA::CBC, key, iv);
		d.update(f);
		TQCString dec = arrayToCString(d.final());
		printf("<aes128(\"%s\") = [%s]\n", result.latin1(), dec.data());
	}

	// BlowFish, TripleDES, and AES256 tested dynamically
	if(!TQCA::isSupported(TQCA::CAP_BlowFish))
		printf("BlowFish not supported!\n");
	else
		doDynTest(new TQCA::BlowFish, "bfish", cs);

	if(!TQCA::isSupported(TQCA::CAP_TripleDES))
		printf("TripleDES not supported!\n");
	else
		doDynTest(new TQCA::TripleDES, "3des", cs);

	if(!TQCA::isSupported(TQCA::CAP_AES256))
		printf("AES256 not supported!\n");
	else
		doDynTest(new TQCA::AES256, "aes256", cs);

	return 0;
}

TQCString arrayToCString(const TQByteArray &a)
{
	TQCString cs;
	cs.resize(a.size()+1);
	memcpy(cs.data(), a.data(), a.size());
	return cs;
}

TQByteArray cstringToArray(const TQCString &cs)
{
	TQByteArray a(cs.length());
	memcpy(a.data(), cs.data(), a.size());
	return a;
}

void doDynTest(TQCA::Cipher *c, const TQString &name, const TQCString &cs)
{
	// encrypt
	TQByteArray key = c->dyn_generateKey();
	TQByteArray iv = c->dyn_generateIV();
	printf("%s:key:%s\n", name.latin1(), TQCA::arrayToHex(key).latin1());
	printf("%s:iv:%s\n", name.latin1(), TQCA::arrayToHex(iv).latin1());
	c->reset(TQCA::Encrypt, TQCA::CBC, key, iv);
	c->update(cstringToArray(cs));
	TQByteArray f = c->final();
	TQString result = TQCA::arrayToHex(f);
	printf(">%s(\"%s\") = [%s]\n", name.latin1(), cs.data(), result.latin1());

	// decrypt
	c->reset(TQCA::Decrypt, TQCA::CBC, key, iv);
	c->update(f);
	TQCString dec = arrayToCString(c->final());
	printf("<%s(\"%s\") = [%s]\n", name.latin1(), result.latin1(), dec.data());
	delete c;
}

