/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "actioneditorimpl.h"
#include "formwindow.h"
#include "metadatabase.h"
#include "actionlistview.h"
#include "connectioneditorimpl.h"
#include "mainwindow.h"

#include <tqaction.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqpopupmenu.h>
#include <tqobjectlist.h>

#include <tdelocale.h>

ActionEditor::ActionEditor( TQWidget* parent,  const char* name, WFlags fl )
    : ActionEditorBase( parent, name, fl ), currentAction( 0 ), formWindow( 0 )
{
    listActions->addColumn( i18n("Actions" ) );
    setEnabled( false );
    buttonConnect->setEnabled( false );

    TQPopupMenu *popup = new TQPopupMenu( this );
    popup->insertItem( i18n("New &Action" ), this, TQ_SLOT( newAction() ) );
    popup->insertItem( i18n("New Action &Group" ), this, TQ_SLOT( newActionGroup() ) );
    popup->insertItem( i18n("New &Dropdown Action Group" ), this, TQ_SLOT( newDropDownActionGroup() ) );
    buttonNewAction->setPopup( popup );
    buttonNewAction->setPopupDelay( 0 );

    connect( listActions, TQ_SIGNAL( insertAction() ), this, TQ_SLOT( newAction() ) );
    connect( listActions, TQ_SIGNAL( insertActionGroup() ), this, TQ_SLOT( newActionGroup() ) );
    connect( listActions, TQ_SIGNAL( insertDropDownActionGroup() ), this, TQ_SLOT( newDropDownActionGroup() ) );
    connect( listActions, TQ_SIGNAL( deleteAction() ), this, TQ_SLOT( deleteAction() ) );
    connect( listActions, TQ_SIGNAL( connectAction() ), this, TQ_SLOT( connectionsClicked() ) );
}

void ActionEditor::closeEvent( TQCloseEvent *e )
{
    emit hidden();
    e->accept();
}

void ActionEditor::currentActionChanged( TQListViewItem *i )
{
    buttonConnect->setEnabled( i != 0 );
    if ( !i )
	return;
    currentAction = ( (ActionItem*)i )->action();
    if ( !currentAction )
	currentAction = ( (ActionItem*)i )->actionGroup();
    if ( formWindow && currentAction )
	formWindow->setActiveObject( currentAction );
}

void ActionEditor::deleteAction()
{
    if ( !currentAction )
	return;

    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == currentAction ) {
	    formWindow->actionList().removeRef( currentAction );
	    delete currentAction;
	    TQValueList<MetaDataBase::Connection> conns =
		MetaDataBase::connections( formWindow, currentAction );
	    for ( TQValueList<MetaDataBase::Connection>::Iterator it2 = conns.begin();
		  it2 != conns.end(); ++it2 )
		MetaDataBase::removeConnection( formWindow, (*it2).sender, (*it2).signal,
						(*it2).receiver, (*it2).slot );
	    delete it.current();
	    break;
	} else if ( ( (ActionItem*)it.current() )->actionGroup() == currentAction ) {
	    formWindow->actionList().removeRef( currentAction );
	    delete currentAction;
	    TQValueList<MetaDataBase::Connection> conns =
		MetaDataBase::connections( formWindow, currentAction );
	    for ( TQValueList<MetaDataBase::Connection>::Iterator it2 = conns.begin();
		  it2 != conns.end(); ++it2 )
		MetaDataBase::removeConnection( formWindow, (*it2).sender, (*it2).signal,
						(*it2).receiver, (*it2).slot );
	    delete it.current();
	    break;
	}
	++it;
    }

    if ( formWindow )
	formWindow->setActiveObject( formWindow->mainContainer() );
}

void ActionEditor::newAction()
{
    ActionItem *actionParent = (ActionItem*)listActions->selectedItem();
    if ( actionParent ) {
	if ( !actionParent->actionGroup() ||
	     !actionParent->actionGroup()->inherits( "TQActionGroup" ) )
	    actionParent = (ActionItem*)actionParent->parent();
    }

    ActionItem *i = 0;
    if ( actionParent )
	i = new ActionItem( actionParent );
    else
	i = new ActionItem( listActions, (bool)false );
    MetaDataBase::addEntry( i->action() );
    TQString n = "Action";
    formWindow->unify( i->action(), n, true );
    i->setText( 0, n );
    i->action()->setName( n.utf8() );
    i->action()->setText( i->action()->name() );
    if ( actionParent && actionParent->actionGroup() &&
	 actionParent->actionGroup()->usesDropDown() ) {
	i->action()->setToggleAction( true );
	MetaDataBase::setPropertyChanged( i->action(), "toggleAction", true );
    }
    MetaDataBase::setPropertyChanged( i->action(), "text", true );
    MetaDataBase::setPropertyChanged( i->action(), "name", true );
    listActions->setCurrentItem( i );
    if ( !actionParent )
	formWindow->actionList().append( i->action() );
}

void ActionEditor::newActionGroup()
{
    ActionItem *actionParent = (ActionItem*)listActions->selectedItem();
    if ( actionParent ) {
	if ( !actionParent->actionGroup() ||
	     !actionParent->actionGroup()->inherits( "TQActionGroup" ) )
	    actionParent = (ActionItem*)actionParent->parent();
    }

    ActionItem *i = 0;
    if ( actionParent )
	i = new ActionItem( actionParent, true );
    else
	i = new ActionItem( listActions, true );

    MetaDataBase::addEntry( i->actionGroup() );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "usesDropDown", true );
    TQString n = "ActionGroup";
    formWindow->unify( i->action(), n, true );
    i->setText( 0, n );
    i->actionGroup()->setName( n.utf8() );
    i->actionGroup()->setText( i->actionGroup()->name() );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "text", true );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "name", true );
    listActions->setCurrentItem( i );
    i->setOpen( true );
    if ( !actionParent )
	formWindow->actionList().append( i->actionGroup() );
}

void ActionEditor::newDropDownActionGroup()
{
    newActionGroup();
    ( (ActionItem*)listActions->currentItem() )->actionGroup()->setUsesDropDown( true );
}

void ActionEditor::setFormWindow( FormWindow *fw )
{
    listActions->clear();
    formWindow = fw;
    if ( !formWindow ||
	 !formWindow->mainContainer() ||
	 !formWindow->mainContainer()->inherits( "TQMainWindow" ) ) {
	setEnabled( false );
    } else {
	setEnabled( true );
	for ( TQAction *a = formWindow->actionList().first(); a; a = formWindow->actionList().next() ) {
	    ActionItem *i = 0;
	    if ( a->parent() && a->parent()->inherits( "TQAction" ) )
		continue;
	    i = new ActionItem( listActions, a );
	    i->setText( 0, a->name() );
	    i->setPixmap( 0, a->iconSet().pixmap() );
	    if ( a->inherits( "TQActionGroup" ) ) {
		insertChildActions( i );
	    }
	}
	if ( listActions->firstChild() ) {
	    listActions->setCurrentItem( listActions->firstChild() );
	    listActions->setSelected( listActions->firstChild(), true );
	}
    }
}

void ActionEditor::insertChildActions( ActionItem *i )
{
    if ( !i->actionGroup() )
	return;
    TQObjectList clo = i->actionGroup()->childrenListObject();
    if (clo.isEmpty())
	return;
    TQObjectListIt it( clo );
    while ( it.current() ) {
	TQObject *o = it.current();
	++it;
	if ( !o->inherits( "TQAction" ) )
	    continue;
	TQAction *a = (TQAction*)o;
	ActionItem *i2 = new ActionItem( (TQListViewItem*)i, a );
	i->setOpen( true );
	i2->setText( 0, a->name() );
	i2->setPixmap( 0, a->iconSet().pixmap() );
	if ( a->inherits( "TQActionGroup" ) )
	    insertChildActions( i2 );
    }
}

void ActionEditor::updateActionName( TQAction *a )
{
    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == a )
	    ( (ActionItem*)it.current() )->setText( 0, a->name() );
	else if ( ( (ActionItem*)it.current() )->actionGroup() == a )
	    ( (ActionItem*)it.current() )->setText( 0, a->name() );
	++it;
    }
}

void ActionEditor::updateActionIcon( TQAction *a )
{
    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == a )
	    ( (ActionItem*)it.current() )->setPixmap( 0, a->iconSet().pixmap() );
	else if ( ( (ActionItem*)it.current() )->actionGroup() == a )
	    ( (ActionItem*)it.current() )->setPixmap( 0, a->iconSet().pixmap() );
	++it;
    }
}

void ActionEditor::connectionsClicked()
{
    ConnectionEditor editor( formWindow->mainWindow(), currentAction, formWindow, formWindow );
    editor.exec();
}
#include "actioneditorimpl.moc"
