/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "perforceintegrator.h"

#include <kdevgenericfactory.h>
#include <kdevplugininfo.h>

#include "pfintegratordlg.h"

static const KDevPluginInfo data("kdevperforceintegrator");
typedef KDevGenericFactory<PerforceIntegrator> PerforceIntegratorFactory;
K_EXPORT_COMPONENT_FACTORY( libperforceintegrator, PerforceIntegratorFactory(data) )

PerforceIntegrator::PerforceIntegrator(TQObject* parent, const char* name,
    const TQStringList // args
                                       )
    :KDevVCSIntegrator(parent, name)
{
}

PerforceIntegrator::~PerforceIntegrator()
{
}

VCSDialog* PerforceIntegrator::fetcher(TQWidget* // parent
                                       )
{
    return 0;
}

VCSDialog* PerforceIntegrator::integrator(TQWidget* parent)
{
    PFIntegratorDlg *dlg = new PFIntegratorDlg(parent);
    return dlg;
}

#include "perforceintegrator.moc"
