/*
 *  Copyright (C) 2003 Roberto Raggi (roberto@kdevelop.org)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef __KDEVPART_QUICKOPEN_H__
#define __KDEVPART_QUICKOPEN_H__

#include <tqguardedptr.h>
#include <kdevquickopen.h>
#include <codemodel.h>

class TDEAction;

class QuickOpenPart : public KDevQuickOpen
{
    TQ_OBJECT
  
public:
    QuickOpenPart(TQObject *parent, const char *name, const TQStringList &);
    virtual ~QuickOpenPart();

    void selectItem( ItemDom item );

    virtual void quickOpenFile(const KURL::List urls);
    
private slots:
    void slotProjectOpened();
    void slotProjectClosed();
    void slotQuickFileOpen();
    void slotQuickOpenClass();
    void slotQuickOpenFunction();
    void slotSwitchTo();

private:
    TDEAction* m_actionQuickOpen;
    TDEAction* m_actionQuickOpenClass;
    TDEAction* m_actionFunctionOpen;
    TDEAction* m_switchToAction;
};


#endif
