/***************************************************************************
 *   Copyright (C) 2005 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#ifndef ADDCATALOGDLG_H
#define ADDCATALOGDLG_H

#include <tqvaluelist.h>
#include "addcatalogdlgbase.h"

class DocumentationPlugin;

class AddCatalogDlg: public AddCatalogDlgBase
{
	TQ_OBJECT
  
	public:
		AddCatalogDlg( TQValueList<DocumentationPlugin*> const & plugins, TQWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0);
		~AddCatalogDlg();
	
		TQString title() const;
		void setTitle(const TQString &title);
		TQString url() const;
		void setURL(const TQString &url);
		DocumentationPlugin * plugin();
		
	public slots:
		virtual void locationURLChanged(const TQString &text);
		virtual void docTypeChanged( const TQString & );
	
	protected slots:
		virtual void accept();
	
	private:
		TQValueList<DocumentationPlugin*> const & m_plugins;
};

#endif
