%{CPP_TEMPLATE}

#include <tqwhatsthis.h>
#include <tqtimer.h>

#include <kiconloader.h>
#include <tdelocale.h>
#include <kgenericfactory.h>
#include <kdevcore.h>
#include <kdevpartcontroller.h>
#include <kdevplugininfo.h>
#include <kdevproject.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <tdeapplication.h>

//#include "%{APPNAMELC}_widget.h"
#include "%{APPNAMELC}_part.h"

typedef KGenericFactory<%{APPNAME}Part> %{APPNAME}Factory;
K_EXPORT_COMPONENT_FACTORY( libkdev%{APPNAMELC}, %{APPNAME}Factory( "kdev%{APPNAMELC}" ) );
static const KDevPluginInfo data("kdev%{APPNAMELC}");

%{APPNAME}Part::%{APPNAME}Part(TQObject *parent, const char *name, const TQStringList& )
: KDevLanguageSupport(&data, parent, name ? name : "%{APPNAME}Part" )
{
	setInstance(%{APPNAME}Factory::instance());
	setXMLFile("kdevlang_%{APPNAMELC}.rc");


	m_build = new TDEAction( i18n("&Run"), "application-x-executable",Key_F9,this, TQ_SLOT(slotRun()),actionCollection(), "build_execute" );

	kdDebug() << "Creating %{APPNAMELC} Part" << endl;

	connect( core(), TQ_SIGNAL(projectConfigWidget(KDialogBase*)),
		this, TQ_SLOT(projectConfigWidget(KDialogBase*)) );
	connect( core(), TQ_SIGNAL(projectOpened()), this, TQ_SLOT(projectOpened()) );
	connect( core(), TQ_SIGNAL(projectClosed()), this, TQ_SLOT(projectClosed()) );
	connect( partController(), TQ_SIGNAL(savedFile(const KURL&)), this, TQ_SLOT(savedFile(const KURL&)) );
	connect(partController(), TQ_SIGNAL(activePartChanged(KParts::Part*)),
		this, TQ_SLOT(slotActivePartChanged(KParts::Part *)));
}


%{APPNAME}Part::~%{APPNAME}Part()
{
	delete m_build;
}

KDevLanguageSupport::Features %{APPNAME}Part::features()
{
	return Features(Variables | Functions);
}
KMimeType::List %{APPNAME}Part::mimeTypes()
{
    KMimeType::List list;

    KMimeType::Ptr mime = KMimeType::mimeType( "application/x-shellscript" );
    if( mime )
	list << mime;

    return list;
}
void %{APPNAME}Part::slotRun()
{
	// Execute the application here.
}
void %{APPNAME}Part::projectConfigWidget(KDialogBase *dlg)
{
	Q_UNUSED( dlg );
	// Create your config dialog here.
}
void %{APPNAME}Part::projectOpened()
{
	kdDebug(9014) << "projectOpened()" << endl;

	connect( project(), TQ_SIGNAL(addedFilesToProject(const TQStringList &)),
		this, TQ_SLOT(addedFilesToProject(const TQStringList &)) );
	connect( project(), TQ_SIGNAL(removedFilesFromProject(const TQStringList &)),
		this, TQ_SLOT(removedFilesFromProject(const TQStringList &)) );

	// We want to parse only after all components have been
	// properly initialized
	TQTimer::singleShot(0, this, TQ_SLOT(parse()));
}
void %{APPNAME}Part::projectClosed()
{

}
void %{APPNAME}Part::savedFile(const KURL &fileName)
{


	if (project()->allFiles().contains(fileName.path().mid ( project()->projectDirectory().length() + 1 )))
	{
		kdDebug(9014) << "parse file " << fileName.path() << endl;
		emit addedSourceInfo( fileName.path() );
	}
}
void %{APPNAME}Part::addedFilesToProject(const TQStringList &fileList)
{
	kdDebug(9014) << "addedFilesToProject()" << endl;

	TQStringList::ConstIterator it;

	for ( it = fileList.begin(); it != fileList.end(); ++it )
	{
		kdDebug(9014) << "maybe parse " << project()->projectDirectory() + "/" + ( *it ) << endl;
	}

	emit updatedSourceInfo();
}
void %{APPNAME}Part::removedFilesFromProject(const TQStringList &fileList)
{


	TQStringList::ConstIterator it;

	for ( it = fileList.begin(); it != fileList.end(); ++it )
	{
		TQString fileName = project()->projectDirectory() + "/" + ( *it );
		if( codeModel()->hasFile(fileName) )
		{
			kdDebug(9014) << "removed " << fileName << endl;
			emit aboutToRemoveSourceInfo( fileName );
			codeModel()->removeFile( codeModel()->fileByName(fileName) );
		}
	}

}
void %{APPNAME}Part::parse()
{
	kdDebug(9014) << "initialParse()" << endl;

	if (project())
	{
		kapp->setOverrideCursor(waitCursor);
		TQStringList files = project()->allFiles();
		for (TQStringList::Iterator it = files.begin(); it != files.end() ;++it)
		{
			kdDebug(9014) << "maybe parse " << project()->projectDirectory() + "/" + (*it) << endl;
		}
		emit updatedSourceInfo();
		kapp->restoreOverrideCursor();
	} else {
		kdDebug(9014) << "No project" << endl;
	}
}
void %{APPNAME}Part::slotActivePartChanged(KParts::Part *part)
{
	kdDebug() << "Changeing active part..." << endl;
}

#include "%{APPNAMELC}_part.moc"
