/***************************************************************************
*   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
*   bernd@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _CONFIGUREOPTIONSWIDGET_H_
#define _CONFIGUREOPTIONSWIDGET_H_

#include "configureoptionswidgetbase.h"

#include <ktrader.h>
#include "domutil.h"


class KDevCompilerOptions;
class AutoProjectPart;
class EnvironmentVariablesWidget;

class ConfigureOptionsWidget : public ConfigureOptionsWidgetBase
{
	TQ_OBJECT
  

public:
	ConfigureOptionsWidget( AutoProjectPart *part, TQWidget *parent = 0, const char *name = 0 );
	~ConfigureOptionsWidget();

public slots:
	void accept();

private:
	virtual void builddirClicked();
	virtual void topsourcedirClicked();
	virtual void setDirty();
	virtual void configChanged( const TQString &config );
	virtual void configComboTextChanged( const TQString &config );
	virtual void configAdded();
	virtual void configRemoved();
	virtual void cflagsClicked();
	virtual void cxxflagsClicked();
	virtual void f77flagsClicked();
	virtual void cserviceChanged();
	virtual void cxxserviceChanged();
	virtual void f77serviceChanged();

	void fixLayout();
	void readSettings( const TQString &config );
	void saveSettings( const TQString &config );

	KDevCompilerOptions *createCompilerOptions( const TQString &lang );
	TDETrader::OfferList coffers, cxxoffers, f77offers;
	TQStringList cservice_names, cservice_execs;
	TQStringList cxxservice_names, cxxservice_execs;
	TQStringList f77service_names, f77service_execs;
	TQStringList allConfigs;
	TQString currentConfig;
	bool dirty;

	AutoProjectPart *m_part;
	EnvironmentVariablesWidget* m_environmentVariablesWidget;
};

#endif 
