/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "hvitem.h"

#include "label.h"

#include <tdeactioncollection.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <kpassivepopup.h>
#include <tdepopupmenu.h>
#include <kstdaction.h>

#include <tqcursor.h>
#include <tqtooltip.h>

HVItem::HVItem( TQWidget *parent, const char *name )
	: BoxContainerItem( 0, name ),
	_label( new Label( parent, "label" ) ),
	_popup( new TDEPopupMenu( _label, "popupmenu" ) ),
	_actions( new TDEActionCollection( _popup, "actions" ) )
{
	_popup->insertTitle( kapp->miniIcon(), kapp->caption() );
	this->fillTDEPopupMenu( _popup, _actions );
	_popup->insertSeparator();
	KStdAction::quit( kapp, TQ_SLOT( quit() ), _actions )->plug( _popup );
	
	connect( _label, TQ_SIGNAL( mouseButtonPressed( TQt::ButtonState ) ), this, TQ_SLOT( mouseButtonPressed( TQt::ButtonState ) ) );
}

HVItem::~HVItem()
{
	//Let everything be deleted by his parents.
}
	
void HVItem::showBox()
{
	_label->show();
}
	
void HVItem::setCount( const int count, const bool newMessages )
{
	drawLabel( _label, count, newMessages );
}

void HVItem::setTooltip( const TQString& string )
{
	TQToolTip::add( _label, string );
}

void HVItem::slotShowPassivePopup( TQPtrList< KornMailSubject >* list, int total, bool date, const TQString& name )
{
	showPassivePopup( _label, list, total, name, date );
}

void HVItem::slotShowPassivePopup( const TQString& errorMessage, const TQString& name )
{
	KPassivePopup::message( TQString( "korn-%1-%2" ).arg( TQString(objId()) ).arg( name ), errorMessage, _label, "Passive error message" );
}
	
void HVItem::doPopup()
{
	_popup->popup( TQCursor::pos() );
}

#include "hvitem.moc"
