#include "objFinder.h"

#include <tqapplication.h>
#include <tqobjectlist.h>
#include <tqwidgetlist.h>

#include <stdlib.h>
#include <time.h>

#include <kdebug.h>

TQDict<TQObject> *objFinder::objList = new TQDict<TQObject>;

/*
 * So we can connect to the slots, etc
 */
objFinder *objFind = new objFinder();

objFinder::objFinder()
  : TQObject()
{
}

objFinder::~objFinder()
{
}

void objFinder::insert(TQObject *obj, const char *key){
  TQString name;

  if(obj == 0x0){
    tqWarning("objFinder: Passed Null Object");
    return;
  }
  
  if(key != 0){
    name = key;
  }
  else {
    name = obj->name();
    if(name == 0){
      name = randString();
    }
  }
  objList->insert(name, obj);
  connect(obj, TQ_SIGNAL(destroyed()),
          objFind, TQ_SLOT(objDest()));
  
  emit objFind->inserted(obj);
}

TQObject *objFinder::find(const char *name, const char *inherits){
  TQObject *found;
  TQDictIterator<TQObject> it(*objList);
  uint len = strlen(name);
  while(it.current()){
    if(len == strlen(it.current()->name()) &&
       strcmp(it.current()->name(), name) == 0)
      return it.current();
    TQObjectList *qobl = it.current()->queryList(inherits, name, FALSE);
    TQObjectListIt itql( *qobl );
    if(itql.current() != 0x0){
      found = itql.current();
      delete qobl;
      return found;
    }
    delete qobl;
    ++it;
  }
  TQWidgetList *all = TQApplication::allWidgets();
  TQWidgetListIt itW(*all);
  while(itW.current()){
    if(len == strlen(itW.current()->name()) &&
       strcmp(itW.current()->name(), name) == 0){
      if(inherits != 0x0 && itW.current()->inherits(inherits) == FALSE){
        ++itW;
        continue;
      }
      found = itW.current();
      delete all;
      return found;
    }
    ++itW;
  }
  delete all;
  
  return 0x0;
}

void objFinder::dumpTree(){
  TQDictIterator<TQObject> it(*objList);
  while(it.current()){
    it.current()->dumpObjectTree();
    ++it;
  }
  TQWidgetList *all = TQApplication::allWidgets();
  TQWidgetListIt itW(*all);
  while(itW.current()){
    kdDebug(5008) << itW.current()->className() << "::" << itW.current()->name("unnamed") << endl;
    ++itW;
  }

}

TQStringList objFinder::allObjects(){
  TQStringList allNames;
  TQDictIterator<TQObject> it(*objList);
  while(it.current()){
    TQObjectList *qobl = it.current()->queryList(); // Matches everything
    TQObjectListIt itql( *qobl );
    while(itql.current()){
      TQString name;
      name = itql.current()->className();
      name += "::";
      name += itql.current()->name("unnamed");
      allNames.append(name);
      ++itql;
    }
    delete qobl;
    ++it;
  }
  TQWidgetList *all = TQApplication::allWidgets();
  TQWidgetListIt itW(*all);
  while(itW.current()){
    TQString name;
    name = itW.current()->className();
    name += "::";
    name += itW.current()->name("unnamed");
    allNames.append(name);
    ++itW;
  }
  delete all;
  return allNames;
}

TQString objFinder::randString(){
  static bool runSrand = 0;
  TQString str = "";
  if(runSrand == 0){
    srand(time(NULL));
  }
  for(int i = 0; i <= 8; i++){
    str.insert(0, (char) (1+(int) (94.0*rand()/(RAND_MAX+1.0))) + 0x20);
  }
  return str;
}

void objFinder::objDest(){
  if(sender() == 0x0){
    return;
  }
  TQDictIterator<TQObject> it(*objList);
  while(it.current()){
    if(it.current() == sender()){
      objList->remove(it.currentKey());
    }
    ++it;
  }
}
#include "objFinder.moc"
