/*
    Kopete Yahoo Protocol
    Add, remove or move a buddy to the Contactlist

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef MODIFYBUDDYTASK_H
#define MODIFYBUDDYTASK_H

#include "task.h"

class TQString;

/**
@author André Duffeck
*/
class ModifyBuddyTask : public Task
{
TQ_OBJECT
  
public:
	enum Type { AddBuddy, RemoveBuddy, MoveBuddy };
	ModifyBuddyTask(Task *parent);
	~ModifyBuddyTask();
	
	virtual void onGo();
	
	bool take(Transfer *transfer);

	void setType( Type type );
	void setMessage( const TQString &text );
	void setTarget( const TQString &target );
	void setGroup( const TQString &group );
	void setOldGroup( const TQString &group );

signals:
	void buddyAddResult( const TQString &, const TQString &, bool );
	void buddyRemoveResult( const TQString &, const TQString &, bool );
	void buddyChangeGroupResult( const TQString &, const TQString &, bool );

protected:
	virtual bool forMe( const Transfer *transfer ) const;

private:
	void addBuddy();
	void removeBuddy();
	void moveBuddy();

	TQString m_message;
	TQString m_target;
	TQString m_group;
	TQString m_oldGroup;
	Type m_type;
};

#endif
