/*
    ircaddcontactpage.h - IRC Add Contact Widget

    Copyright (c) 2002      by Nick Betcher <nbetcher@kde.org>

    Kopete    (c) 2002      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef IRCADDCONTACTPAGE_H
#define IRCADDCONTACTPAGE_H

#include "addcontactpage.h"

class ircAddUI;
namespace Kopete { class MetaContact; }
class IRCAccount;
class TQListViewItem;
class ChannelList;

/**
  *@author Nick Betcher <nbetcher@kde.org>
  */
class IRCAddContactPage : public AddContactPage
{
   TQ_OBJECT
  
public:
	IRCAddContactPage(TQWidget *parent=0, IRCAccount* account = 0);
	~IRCAddContactPage();
	ircAddUI *ircdata;

public slots:
	virtual bool apply(Kopete::Account *account , Kopete::MetaContact *m);

private slots:
	virtual bool validateData();
	void slotChannelSelected( const TQString &channel );
	void slotChannelDoubleClicked( const TQString &channel );
private:
	IRCAccount *mAccount;
	ChannelList *mSearch;
};

#endif
