/***************************************************************************
                          cryptographyselectuserkey.cpp  -  description
                             -------------------
    begin                : dim nov 17 2002
    copyright            : (C) 2002 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <tqpushbutton.h>
#include <tqlabel.h>

#include "cryptographyuserkey_ui.h"
#include "kopetemetacontact.h"
#include "popuppublic.h"

#include "cryptographyselectuserkey.h"

CryptographySelectUserKey::CryptographySelectUserKey(const TQString& key ,Kopete::MetaContact *mc) : KDialogBase( 0l, "CryptographySelectUserKey", /*modal = */true, i18n("Select Contact's Public Key") , KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok )
{
	m_metaContact=mc;
	view = new CryptographyUserKey_ui(this,"CryptographyUserKey_ui");
	setMainWidget(view);

	connect (view->m_selectKey , TQ_SIGNAL(clicked()) , this , TQ_SLOT(slotSelectPressed()));
	connect (view->m_removeButton , TQ_SIGNAL(clicked()) , this , TQ_SLOT(slotRemovePressed()));

	view->m_titleLabel->setText(i18n("Select public key for %1").arg(mc->displayName()));
	view->m_editKey->setText(key);
}
CryptographySelectUserKey::~CryptographySelectUserKey()
{
}

void CryptographySelectUserKey::slotSelectPressed()
{
	popupPublic *dialog=new popupPublic(this, "public_keys", 0,false);
	connect(dialog,TQ_SIGNAL(selectedKey(TQString &,TQString,bool,bool)),this,TQ_SLOT(keySelected(TQString &)));
	dialog->show();
}


void CryptographySelectUserKey::keySelected(TQString &key)
{
	view->m_editKey->setText(key);
}

void CryptographySelectUserKey::slotRemovePressed()
{
	view->m_editKey->setText("");
}

TQString CryptographySelectUserKey::publicKey() const
{
	return view->m_editKey->text();
}



#include "cryptographyselectuserkey.moc"

