/*
    appearanceconfig.cpp  -  Kopete Look Feel Config

    Kopete    (c) 2002-2009 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef EMOTICONSEDITDIALOG_H
#define EMOTICONSEDITDIALOG_H

#include <kdebug.h>
#include <tqhbox.h>
#include <kdialogbase.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <tqfile.h>
#include <tqdom.h>

class EmoticonsEditWidget;

class EditDialog : public KDialogBase
{
    TQ_OBJECT
  

    public:
        EditDialog(TQWidget *parent, const char* name);
        EditDialog(TQWidget *parent, const char* name, TQPixmap emot, TQString text, TQString file);
        const TQString getText() { return leText->text(); };
        const TQString getEmoticon() { return emoticon; };
    private slots:
        void btnIconClicked();
    private:
        void setupDlg();
        TQWidget *wdg;
        KLineEdit *leText;
        KPushButton *btnIcon;
        TQString emoticon;
};

class EmoticonsEditDialog : public KDialogBase
{
    TQ_OBJECT
  

    public:
        EmoticonsEditDialog(TQWidget *parent=0, TQString theme = TQString(), const char* name="EmoticonsEditDialog");
        void addEmoticon(TQString emo, TQString text, bool copy);

    private slots:
        void slotOkClicked();
        void slotAddClicked();
        void slotEditClicked();
        void slotRemoveClicked();

    private:
        void removeEmoticon(TQString emo);
        EmoticonsEditWidget *mMainWidget;
        TQString themeName;
        EditDialog *dlg;
        TQDomDocument themeXml;
};

#endif
