/**
 * Copyright (C) 2003, Lus Pedro Coelho,
 * based on tdelibs/tdeparts/genericfactory.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tdeparts/factory.h>
#include <tdeparts/part.h>
#include <kgenericfactory.h>
#include <tdeaboutdata.h>
#include <kdebug.h>
#include "kgv_view.h"

#include "kgvfactory.h"

KGVFactory::KGVFactory()
{
    if ( s_self )
        kdWarning() << "KGVFactory instantiated more than once!" << endl;
    s_self = this;
}

KGVFactory::~KGVFactory()
{
    delete s_aboutData;
    delete s_instance;
    s_aboutData = 0;
    s_instance = 0;
    s_self = 0;
}

TDEInstance *KGVFactory::createInstance()
{
    TDEInstance* res = new TDEInstance( aboutData() );
    return res;
}

KGVFactory *KGVFactory::s_self;
TDEInstance *KGVFactory::s_instance;
TDEAboutData *KGVFactory::s_aboutData;

KParts::Part *KGVFactory::createPartObject( TQWidget *parentWidget, const char *widgetName,
        TQObject *parent, const char *name,
        const char *className,
        const TQStringList &args_ )
{
    TQStringList args = args_;
    /* Below is the reason why we must
     * have our own factory instead of
     * typedef KParts::GenericFactory<KGVPart> KGVFactory
     *
     * as we did before.
     */
    args << TQString::fromLatin1( className );
    if ( !strcmp( className, "Browser/View" ) ) {
	    className = "KParts::ReadOnlyPart";
    }
    KGVPart *part = KDEPrivate::ConcreteFactory<KGVPart>::create( parentWidget,
            widgetName,
            parent,
            name,
            className,
            args );

    if ( part && !qstrcmp( className, "KParts::ReadOnlyPart" ) )
    {
        KParts::ReadWritePart *rwp = dynamic_cast<KParts::ReadWritePart *>( part );
        if ( rwp )
            rwp->setReadWrite( false );
    }
    return part;
}

TDEInstance *KGVFactory::instance()
{
    if ( !s_instance )
    {
        if ( s_self )
            s_instance = s_self->createInstance();
        else
            s_instance = new TDEInstance( aboutData() );
    }
    return s_instance;
}

TDEAboutData *KGVFactory::aboutData()
{
    if ( !s_aboutData )
        s_aboutData = KGVPart::createAboutData();
    return s_aboutData;
}

