#include <limits.h>

#include "int_validator.h"
#include "int_validator.moc"

IntValidator::IntValidator( TQWidget *parent, const char *name ) :
    TQValidator( parent, name )
{
#ifdef INT_MIN
    v_bottom = INT_MIN;
#else
    v_bottom = ~INT_MAX;
#endif
    v_top = INT_MIN;
}

IntValidator::IntValidator( int bottom, int top, TQWidget *parent, const char *name ) :
TQValidator( parent, name )
{
    v_bottom = bottom;
    v_top = top;
}

IntValidator::~IntValidator() {}

TQValidator::State
IntValidator::validate( TQString &input, int & ) const
{
    if( input.isEmpty() ) {
        return TQValidator::Valid;
    } else {
        bool ok;

        int value = input.toInt( &ok );

        if( !ok )
            return TQValidator::Invalid;

        if( value < v_bottom || value > v_top )
            return TQValidator::Valid;

        return TQValidator::Acceptable;
    }
}

void
IntValidator::setRange( int b, int t )
{
    v_bottom = b;
    v_top = t;
}


