/***************************************************************************
                          wqscore.cpp  -  description
                             -------------------
   copyright            : (C) 2003 by Peter Hedlund
   email                : peter.hedlund@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wqscore.h"

WTQScore::WTQScore()
{
  m_questionCount = 0;
  m_percent = false;
  m_error = 0;
  m_correct = 0;
  m_answerCount = 0;
}


WTQScore::~WTQScore()
{}


void WTQScore::setAsPercent(bool p)
{
  m_percent = p;
}

void WTQScore::setQuestionCount(int c)
{
  m_questionCount = c;
  //m_percent = false;
  m_error = 0;
  m_correct = 0;
  m_answerCount = 0;
}

void WTQScore::countIncrement(CountDirection d)
{

  if (d != cdNone)
    m_answerCount++;
  if (d == cdCorrect)
    m_correct++;
  if (d == cdError)
    m_error++;
}

/*!
    \fn WTQScore::answerText()
 */
TQString WTQScore::answerText()
{
  TQString s;
  if (m_percent)
  {
    float f = ((m_answerCount * 100.0) / m_questionCount);
    if (m_answerCount > 0)
    {
      if (f < 1)
        s = s.setNum(f, 'f', 1) + "%"; //for long lists (i.e. each question is less than 1%) we show one decimal 
      else
        s = s.setNum(f, 'f', 0) + "%";
    }
    else
      s= valueToString(m_answerCount);
  }
  else
    s = valueToString(m_answerCount);
  return s;
}

/*!
    \fn WTQScore::correctText()
 */
TQString WTQScore::correctText()
{
  TQString s;
  if (m_percent)
  {
    if (m_correct > 0)
    {
      float f = ((m_correct * 100.0) / m_answerCount);
      s = s.setNum(f, 'f', 0) + "%";
    }
    else
      s = valueToString(m_correct);

  }
  else
    s = valueToString(m_correct);
  return s;
}

/*!
    \fn WTQScore::errorText()
 */
TQString WTQScore::errorText()
{
  TQString s;
  if (m_percent)
  {
    if (m_error > 0)
    {
      float f = ((m_error * 100.0) / m_answerCount);
      s = s.setNum(f, 'f', 0) + "%";
    }
    else
      s = valueToString(m_error);

  }
  else
    s = valueToString(m_error);
  return s;
}

/*!
    \fn WTQScore::valueToString(int i)
 */
TQString WTQScore::valueToString(int i)
{
  TQString s = ""; //return empty string for 0

  if (i > 0)
    s = s.setNum(i, 10);

  return s;
}




