/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.Random;

//
// ConnectWidget - draws connected lines
//
class ConnectWidget  extends TQWidget
{
static final int MAXPOINTS = 2000;			// maximum number of points
static final int MAXCOLORS = 40;

private    TQPoint[]     points;				// point array
private    TQColor[]     colors;				// color array
private    int		count;				// count = number of points
private    boolean	down;				// true if mouse down
private    Random generator = new Random(System.currentTimeMillis());

//
// Constructs a ConnectWidget.
//
public ConnectWidget( )
{
	this(null, null);
}

public ConnectWidget( TQWidget parent, String name )
{
    super( parent, name, WStaticContents );
    setBackgroundColor( white() );		// white background
    count = 0;
    down = false;
    points = new TQPoint[MAXPOINTS];
    colors = new TQColor[MAXCOLORS];
    for ( int i=0; i<MAXCOLORS; i++ )		// init color array
	colors[i] = new TQColor( generator.nextInt(255), generator.nextInt(255), generator.nextInt(255) );
}


//
// Handles paint events for the connect widget.
//

protected void paintEvent( TQPaintEvent e  )
{
    TQPainter paint = new TQPainter( this );
    for ( int i=0; i<count-1; i++ ) {		// connect all points
	for ( int j=i+1; j<count; j++ ) {
	    paint.setPen( colors[generator.nextInt(MAXCOLORS)] ); // set random pen color
	    paint.drawLine( points[i], points[j] ); // draw line
	}
    }
    paint.end();
}


//
// Handles mouse press events for the connect widget.
//

protected void mousePressEvent( TQMouseEvent e  )
{
    down = true;
    count = 0;					// start recording points
    erase();					// erase widget contents
}


//
// Handles mouse release events for the connect widget.
//

protected void mouseReleaseEvent( TQMouseEvent e )
{
    down = false;				// done recording points
    update();					// draw the lines
}


//
// Handles mouse move events for the connect widget.
//

protected void mouseMoveEvent( TQMouseEvent e )
{
    if ( down && count < MAXPOINTS ) {
	TQPainter paint = new TQPainter( this );
	points[count++] = new TQPoint(e.pos());		// add point
	paint.drawPoint( e.pos() );		// plot point
	paint.end();
    }
}


//
// Create and display a ConnectWidget.
//

public static void main( String[] args )
{
    TQApplication a = new TQApplication( args );
    ConnectWidget connect = new ConnectWidget();
    connect.setCaption( "Qt Example - Draw lines");
    a.setMainWidget( connect );
    connect.show();
    a.exec();
	return;
}

static {
	qtjava.initialize();
}

}
