
#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqframe.h>
#include "qframe_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {
void TQFrameImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum Shape
        { "NoFrame", TQFrame::NoFrame },
        { "Box", TQFrame::Box },
        { "Panel", TQFrame::Panel },
        { "WinPanel", TQFrame::WinPanel },
        { "HLine", TQFrame::HLine },
        { "VLine", TQFrame::VLine },
        { "StyledPanel", TQFrame::StyledPanel },
        { "PopupPanel", TQFrame::PopupPanel },
        { "MenuBarPanel", TQFrame::MenuBarPanel },
        { "ToolBarPanel", TQFrame::ToolBarPanel },
        { "LineEditPanel", TQFrame::LineEditPanel },
        { "TabWidgetPanel", TQFrame::TabWidgetPanel },
        { "GroupBoxPanel", TQFrame::GroupBoxPanel },
        { "MShape", TQFrame::MShape },
        // enum Shadow
        { "Plain", TQFrame::Plain },
        { "Raised", TQFrame::Raised },
        { "Sunken", TQFrame::Sunken },
        { "MShadow", TQFrame::MShadow },
	{ 0, 0 }
    };

    int enumidx = 0;
    do {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    } while( enums[enumidx].id );

}

} // namespace KJSEmbed
