/***************************************************************************
*   Copyright (C) 2003 by Sandro Giessl                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef MALLORYCONFIG_H
#define MALLORYCONFIG_H

#include <tqobject.h>

class TQButtonGroup;
class TQGroupBox;
class TQComboBox;
class TDEConfig;
class ConfigDialog;

class MalloryConfig : public TQObject
{
    TQ_OBJECT
public:
    MalloryConfig(TDEConfig* config, TQWidget* parent); ///< Constructor
    ~MalloryConfig(); ///< Destructor

signals:
    void changed(); ///< Widget state has changed

public slots:
    void load(TDEConfig *config); ///< Load configuration data
    void save(TDEConfig *config); ///< Save configuration data
    void defaults(); ///< Set configuration defaults

private:
    TDEConfig *m_config;
    ConfigDialog *m_dialog;
};

#endif
