/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "parsers.h"
#include "../apt.h"

static TQString
  html_dpkgs_line_begin("<tr><td class=\"file\">%1</td><td>\n\t"),
  html_dpkgs_line_end("\n</td></tr>\n");

namespace Parsers
{

void FileSearch::operator() (AptProtocol* slave, const TQString & tag, const TQString & value )
{
  static TQString buffer;
  if (tag == "begin")
  {
  	m_result_count = 0;
  }
  else if (tag == "error")
  {
    *slave << "<div class=\"error\">" + value + "</div>";
  }
  else if (tag == "file")
  {
    if (m_result_count)
      *slave << buffer + html_dpkgs_line_end;

    *slave << html_dpkgs_line_begin.arg(value);
    ++m_result_count;
    buffer = "";
  }
  else if (tag == "package")
  {
    if (!buffer.isEmpty()) buffer = buffer + ", ";
    buffer += "<a href=\"apt:/show?" + value + "\">" + value + "</a>";
  }
  else if (tag == "end")
  {
    *slave << buffer + html_dpkgs_line_end;
    buffer="";
  }
}

}
