/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//TQt includes
#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>

//KDE includes
#include <tdelocale.h>
#include <tdeactioncollection.h>
#include <kbuttonbox.h>
#include <tdelistbox.h>
#include <tdefiledialog.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "cronOptions.h"
#include "ksystemlogConfig.h"

CronOptions::CronOptions(TQWidget *parent) : 
	TQWidget(parent)
	{
	
	TQHBoxLayout *layout = new TQHBoxLayout(this);
	layout->setAutoAdd(true);

	TQString description= i18n("<qt><p>These files will be analyzed to display <b>Cron Logs</b> (planned tasks logs). This list also determines the order in which the files are read.</p></qt>");
	fileList=new SpecificFileList(this, description);
	
	connect(fileList, TQ_SIGNAL(fileListChanged(int)), this, TQ_SLOT(slotFileListChanged(int)));

	readConfig();
	

}

CronOptions::~CronOptions() {
	//TODO Delete fileList
}

bool CronOptions::isValid() {
	if (fileList->count()>0)
		return(true);
	else
		return(false);
}

void CronOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void CronOptions::saveConfig() {
	kdDebug() << "Saving config from Cron Options..." << endl;
	
	TQStringList stringList;
	TQValueList<int> valueList;
		
	fileList->saveConfig(stringList, valueList);
	
	KSystemLogConfig::setCronPaths(stringList);
	KSystemLogConfig::setCronLevels(valueList);
}

void CronOptions::readConfig() {
	TQStringList stringList=KSystemLogConfig::cronPaths();
	TQValueList<int> valueList=KSystemLogConfig::cronLevels();
	
	fileList->readConfig(stringList, valueList);
}

#include "cronOptions.moc"
