/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_INDEX_ITEM_H
#define KBFX_PLASMA_INDEX_ITEM_H

#include "kbfxplasmacanvasabstractitem.h"

class KbfxPlasmaIndexItem : public KbfxPlasmaCanvasAbstractItem
{
		TQ_OBJECT
  

	public:

		KbfxPlasmaIndexItem ( TQCanvasPixmapArray * a, TQCanvas * canvas );
		virtual ~KbfxPlasmaIndexItem();

		void setIcon ( TQString path );
		void setText ( TQString text );
		void setId ( int id );
		//void setName(TQString name);
		void setLabelText ( TQString text );
		void setBelongsTo ( TQString parent );
		TQString belongsTo();
		int height();
		void setSelected ( bool select );
		bool  selected();
		int Id() { return m_id;}

		virtual void drawContent ( TQPainter * pe );
		virtual void draw ( TQPainter & pe );
		virtual void mousePressEvent ( TQMouseEvent * e );

	private:
		int m_id;
		TQString  m_name;
		TQString m_text;
		TQString m_iconPath;
		TQPixmap m_icon;
		TQString m_parent;
		bool m_isCurrent;
		int m_height;
		int m_width;
		bool m_isSelected;


};


#endif
