/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __VTEXTTOOL_H__
#define __VTEXTTOOL_H__


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

#include "tqframe.h"
#include "tqgroupbox.h"
#include "tqcombobox.h"

#include "vcommand.h"
#include "vtext.h"
#include "vtool.h"

class TDEFontCombo;
class KIntNumInput;
class TQCheckBox;
class TQLineEdit;
class TQPushButton;
class TQTabWidget;
class ShadowWidget;
class VTextTool;
class TQCursor;

class ShadowPreview : public TQWidget
{
	TQ_OBJECT
  

public:
	ShadowPreview( ShadowWidget* parent );
	~ShadowPreview();

signals:
	void changed( int angle, int distance, bool );

protected:
	virtual void mouseReleaseEvent( TQMouseEvent* );
	virtual void paintEvent( TQPaintEvent* );

private:
	ShadowWidget* m_parent;
};


class ShadowWidget : public TQGroupBox
{
	TQ_OBJECT
  

public:
	ShadowWidget( TQWidget* parent, const char* name, int angle, int distance, bool translucent );
	~ShadowWidget();

	void setUseShadow( bool use );
	bool useShadow();
	void setShadowAngle( int angle );
	int shadowAngle();
	void setShadowDistance( int distance );
	int shadowDistance();
	void setTranslucent( bool translucent );
	bool isTranslucent();

public slots:
	void setShadowValues( int angle, int distance, bool translucent );
	void updatePreview( int );
	void updatePreview();

protected:
	TQCheckBox* m_useShadow;
	KIntNumInput* m_angle;
	KIntNumInput* m_distance;
	TQCheckBox* m_translucent;
	ShadowPreview* m_preview;
};


class VTextOptionsWidget : public KDialogBase
{
	TQ_OBJECT
  

public:
	VTextOptionsWidget( VTextTool* tool, TQWidget *parent );
	~VTextOptionsWidget();

	void setFont( const TQFont& font );
	TQFont font();
	void setText( const TQString& text );
	TQString text();
	void setPosition( VText::Position position );
	VText::Position position();
	void setAlignment( VText::Alignment alignment );
	VText::Alignment alignment();
	void setOffset( double offset );
	double offset();
	void setUseShadow( bool state );
	bool useShadow();
	void setShadow( int angle, int distance, bool translucent );
	bool translucentShadow();
	int shadowAngle();
	int shadowDistance();

public slots:
	void valueChanged( int );
	void valueChanged( double );
	void accept();
	void cancel();
	void textChanged( const TQString& );
	void editBasePath();
	void convertToShapes();
	void initialize( VObject &text );

protected:
	TQTabWidget* m_tabWidget;
	TDEFontCombo* m_fontCombo;
	TQCheckBox* m_boldCheck;
	TQCheckBox* m_italicCheck;
	KIntNumInput* m_fontSize;
	TQLineEdit* m_textEditor;
	ShadowWidget* m_shadow;
	TQComboBox* m_textAlignment;
	TQComboBox* m_textPosition;
	TQPushButton* m_editBasePath;
	TQPushButton* m_convertToShapes;
	KDoubleNumInput* m_textOffset;
	VTextTool* m_tool;
};


class VTextTool : public VTool, public VVisitor
{
public:
	VTextTool( KarbonView *view );
	~VTextTool();

	virtual void setup (TDEActionCollection *collection );
	virtual TQString uiname() { return i18n( "Text Tool" ); }

	virtual TQString contextHelp();
	virtual bool showDialog() const;

	virtual void activate();
	virtual void deactivate();

	virtual void mouseButtonPress();
	virtual void mouseButtonRelease();
	virtual void mouseDrag();
	virtual void mouseDragRelease();
	virtual void textChanged();
	virtual void accept();
	virtual void cancel();
	virtual void editBasePath();
	virtual void convertToShapes();

	virtual void visitVPath( VPath& composite );
	virtual void visitVDocument( VDocument& )
	{}

	virtual void visitVGroup( VGroup& )
	{}

	virtual void visitVLayer( VLayer& )
	{}

	virtual void visitVSubpath( VSubpath& path );
	virtual void visitVText( VText& text );

	virtual void draw( VPainter* painter );

protected:
	virtual void mouseDragShiftPressed();
	virtual void mouseDragShiftReleased();

private:
	class VTextCmd : public VCommand
	{
	public:
		VTextCmd( VDocument* doc, const TQString& name, VText* text );
		VTextCmd( VDocument* doc, const TQString& name, VText* text,
				  const TQFont &newFont, const VSubpath& newBasePath, VText::Position newPosition, VText::Alignment newAlignment, double newOffset, const TQString& newText,
				  bool newUseShadow, int newShadowAngle, int newShadowDistance, bool newTranslucentShadow );
		virtual ~VTextCmd();

		virtual void execute();
		virtual void unexecute();
		virtual bool isExecuted()
		{
			return m_executed;
		}
		virtual bool changesSelection() const { return true; }

	private:
		class VTextModifPrivate
		{
		public:
			VTextModifPrivate() : oldBasePath( 0L ), newBasePath( 0L )
			{}

			TQFont oldFont;
			TQFont newFont;
			VSubpath oldBasePath;
			VSubpath newBasePath;
			VText::Position oldPosition;
			VText::Position newPosition;
			VText::Alignment oldAlignment;
			VText::Alignment newAlignment;
			double oldOffset;
			double newOffset;
			TQString oldText;
			TQString newText;
			bool oldUseShadow;
			bool newUseShadow;
			int oldShadowAngle;
			int newShadowAngle;
			int oldShadowDistance;
			int newShadowDistance;
			bool oldTranslucentShadow;
			bool newTranslucentShadow;
		};

		VText* m_text;
		bool m_executed;
		VTextModifPrivate* m_textModifications;
	};

	class VTextToCompositeCmd : public VCommand
	{
	public:
		VTextToCompositeCmd( VDocument* doc, const TQString& name, VText* text );
		virtual ~VTextToCompositeCmd();

		virtual void execute();
		virtual void unexecute();
		virtual bool isExecuted()
		{
			return m_executed;
		}

	private:
		VText* m_text;
		VGroup* m_group;
		bool m_executed;
	};

	void drawPathCreation();
	void drawEditedText();
	
	/**
	* Creates new temporary text object along given path for displaying.
	*
	* @param path the path to create the text along
	*/
	bool createText( VSubpath &path );

	VTextOptionsWidget* m_optionsWidget;
	KoPoint m_last;
	VText* m_text;
	VText* m_editedText;
	bool m_creating;
	// are we dragging in 45 degree steps?
	bool m_stepwise;
	TQCursor* m_cursor;
};

#endif

