/*
   This file is part of the KDE project
   Copyright 2001, 2002, 2003, 2004 Nicolas GOUTTE <goutte@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqbuffer.h>
#include <tqimage.h>

#include <kdebug.h>

#include <KoPicture.h>

#include "KWEFStructures.h"
#include "KWEFBaseWorker.h"
#include "KWEFKWordLeader.h"

void KWEFBaseWorker::registerKWordLeader(KWEFKWordLeader* leader)
{
    m_kwordLeader=leader;
}

//
// At first, define all methods that do something real!
//

bool KWEFBaseWorker::doAbortFile(void)
{
    // Mostly, aborting is the same than closing the file!
    return doCloseFile();
}

bool KWEFBaseWorker::doFullDocument (const TQValueList<ParaData>& paraList)
{
    if (!doOpenTextFrameSet())
        return false;
    if (!doFullAllParagraphs(paraList))
        return false;
    if (!doCloseTextFrameSet())
        return false;

    return true;
}

bool KWEFBaseWorker::doFullAllParagraphs (const TQValueList<ParaData>& paraList)
{
    TQValueList<ParaData>::ConstIterator it;
	TQValueList<ParaData>::ConstIterator end(paraList.end());
    for (it=paraList.begin();it!=end;++it)
    {
        if (!doFullParagraph((*it).text,(*it).layout,(*it).formattingList))
            return false;
    }
    return true;
}

bool KWEFBaseWorker::loadSubFile(const TQString& fileName, TQByteArray& array) const
// return value:
//   true if the file is not empty
//   false if the file is empty or if an error occurred
{
    bool flag=false;
    if (m_kwordLeader)
    {
        flag=m_kwordLeader->loadSubFile(fileName,array);
    }
    else
    {
        kdWarning(30508) << "Leader is unknown! (KWEFBaseWorker::loadSubFile)" << endl;
    }
    return flag;
}

TQIODevice* KWEFBaseWorker::getSubFileDevice(const TQString& fileName) const
{
    if (!m_kwordLeader)
    {
        kdWarning(30508) << "Leader is unknown! (KWEFBaseWorker::getSubFileDevice)" << endl;
        return NULL;
    }
    return m_kwordLeader->getSubFileDevice(fileName);
}

TQImage KWEFBaseWorker::loadAndConvertToImage(const TQString& strName, const TQString& inExtension) const
{
    TQIODevice* io=getSubFileDevice(strName);
    if (!io)
    {
        // NO message error, as there must be already one
        return TQImage();
    }

    kdDebug(30508) << "Picture " << strName << " has size: " << io->size() << endl;
    
    KoPicture picture;
    if (!picture.load(io, inExtension)) // we do not care about KoPictureKey
    {
        kdWarning(30508) << "Could not read picture: " << strName << " (KWEFBaseWorker::loadAndConvertToImage)" << endl;
        return TQImage();
    }
    
    return picture.generateImage(picture.getOriginalSize()); // ### TODO: KoPicture::getOriginalSize is bad for cliparts
}

bool KWEFBaseWorker::loadAndConvertToImage(const TQString& strName, const TQString& inExtension, const TQString& outExtension, TQByteArray& image) const
{
    TQImage qimage(loadAndConvertToImage(strName,inExtension));
    
    if (qimage.isNull())
    {
        kdWarning(30508) << "Could not load image (KWEFBaseWorker::loadAndConvertToImage)" <<endl;
        return false;
    }
    
    TQImageIO imageIO;
    imageIO.setImage(qimage);

    TQBuffer buffer(image); // A TQBuffer is a TQIODevice
    if (!buffer.open(IO_WriteOnly))
    {
        kdWarning(30508) << "Could not open buffer! (KWEFBaseWorker::loadAndConvertToImage)" << endl;
        return false;
    }

    imageIO.setIODevice(&buffer);
    imageIO.setFormat(outExtension.utf8());

    if (!imageIO.write())
    {
        kdWarning(30508) << "Could not write converted image! (KWEFBaseWorker::loadAndConvertToImage)" << endl;
        return false;
    }
    buffer.close();

    return true;
}


//
// Secondly, define all methods returning false
//

#define DO_FALSE_DEFINITION(string) \
    bool KWEFBaseWorker::string \
    {\
        kdWarning(30508) << "KWEFBaseWorker::" << #string << " was called (Worker not correctly defined?)" << endl; \
        return false;\
    }

DO_FALSE_DEFINITION (doOpenFile (const TQString& , const TQString& ))
DO_FALSE_DEFINITION (doCloseFile (void))
DO_FALSE_DEFINITION (doOpenDocument (void))
DO_FALSE_DEFINITION (doCloseDocument (void))

// The following is not generated by the leader
DO_FALSE_DEFINITION (doFullParagraph(const TQString&, const LayoutData&, const ValueListFormatData&))

//
// Thirdly, define all methods returning true
//

#define DO_TRUE_DEFINITION(string) \
    bool KWEFBaseWorker::string \
    {\
        return true;\
    }

DO_TRUE_DEFINITION (doFullDocumentInfo (const KWEFDocumentInfo&))
DO_TRUE_DEFINITION (doVariableSettings (const VariableSettingsData &))
DO_TRUE_DEFINITION (doFullPaperFormat (const int, const double, const double, const int))
DO_TRUE_DEFINITION (doFullPaperBorders (const double, const double, const double, const double))
DO_TRUE_DEFINITION (doFullPaperFormatOther ( const int, const double, const int ) )
DO_TRUE_DEFINITION (doPageInfo(int,int))
DO_TRUE_DEFINITION (doOpenHead (void))
DO_TRUE_DEFINITION (doCloseHead (void))
DO_TRUE_DEFINITION (doOpenBody (void))
DO_TRUE_DEFINITION (doCloseBody (void))
DO_TRUE_DEFINITION (doOpenStyles (void))
DO_TRUE_DEFINITION (doCloseStyles (void))
DO_TRUE_DEFINITION (doFullDefineStyle (LayoutData&))
DO_TRUE_DEFINITION (doOpenSpellCheckIgnoreList (void))
DO_TRUE_DEFINITION (doCloseSpellCheckIgnoreList (void))
DO_TRUE_DEFINITION (doFullSpellCheckIgnoreWord (const TQString&))
DO_TRUE_DEFINITION (doHeader(const HeaderData&))
DO_TRUE_DEFINITION (doFooter(const FooterData&))
DO_TRUE_DEFINITION ( doDeclareNonInlinedFramesets( TQValueList<FrameAnchor>&, TQValueList<FrameAnchor>& ) )

//  The following are not generated by the leader
DO_TRUE_DEFINITION (doOpenTextFrameSet (void))
DO_TRUE_DEFINITION (doCloseTextFrameSet (void))
