/* This file is part of the KDE project
   Copyright (C) 2003 Norbert Andres <nandres@web.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#ifndef OPENCALCSTYLEEXPORT_H
#define OPENCALCSTYLEEXPORT_H

#include "kspread_format.h"

#include <tqcolor.h>
#include <tqfont.h>
#include <tqptrlist.h>
#include <tqstring.h>

namespace KSpread
{
  class Cell;
}

class TQDomDocument;
class TQDomElement;

typedef enum T1 { Boolean, Date, Number, Percentage, Time } NumberType;

class Style
{
 public:
  enum breakBefore { none, automatic, page };

  Style() : breakB( none ), size( 0.0 ) {}

  TQString name;
  uint    breakB;
  double  size;
};

class SheetStyle
{
 public:
  SheetStyle() : visible( true ) {}

  void copyData( SheetStyle const & ts ) { visible = ts.visible; }
  static bool isEqual( SheetStyle const * const t1, SheetStyle const & t2 );

  TQString     name;
  bool        visible;
};

class NumberStyle
{
 public:
  NumberStyle() {}

  void copyData( NumberStyle const & ts ) { type = ts.type; }
  static bool isEqual( NumberStyle const * const t1, NumberStyle const & t2 );

  TQString     name;

  NumberType  type;
  TQString     pattern;
};

class CellStyle
{
 public:
  CellStyle();

  void copyData( CellStyle const & ts );
  static bool isEqual( CellStyle const * const t1, CellStyle const & t2 );

  // all except the number style
  static void loadData( CellStyle & cs, KSpread::Cell const * const cell );

  TQString     name;

  TQFont       font;
  TQString     numberStyle;
  TQColor      color;
  TQColor      bgColor;
  double      indent;
  bool        wrap;
  bool        vertical;
  int         angle;
  bool        print;
  TQPen        left;
  TQPen        right;
  TQPen        top;
  TQPen        bottom;
  bool        hideAll;
  bool        hideFormula;
  bool        notProtected;

  KSpread::Format::Align  alignX;
  KSpread::Format::AlignY alignY;
};

class ColumnStyle : public Style
{
 public:
  ColumnStyle() : Style() {}

  void copyData( ColumnStyle const & cs );
  static bool isEqual( ColumnStyle const * const c1, ColumnStyle const & c2 );
};

class RowStyle : public Style
{
 public:
  RowStyle() : Style() {}

  void copyData( RowStyle const & cs );
  static bool isEqual( RowStyle const * const c1, RowStyle const & c2 );
};

class OpenCalcStyles
{
 public:
  OpenCalcStyles();
  ~OpenCalcStyles();

  void    writeStyles  ( TQDomDocument & doc, TQDomElement & autoStyles );
  void    writeFontDecl( TQDomDocument & doc, TQDomElement & content );

  void    addFont( TQFont const & font, bool def = false );

  TQString cellStyle( CellStyle const & cs );
  TQString columnStyle( ColumnStyle const & cs );
  TQString numberStyle( NumberStyle const & ns );
  TQString rowStyle( RowStyle const & rs );
  TQString sheetStyle( SheetStyle const & ts );

 private:
  TQPtrList<CellStyle>   m_cellStyles;
  TQPtrList<ColumnStyle> m_columnStyles;
  TQPtrList<NumberStyle> m_numberStyles;
  TQPtrList<RowStyle>    m_rowStyles;
  TQPtrList<SheetStyle>  m_sheetStyles;
  TQPtrList<TQFont>       m_fontList;

  TQFont                 m_defaultFont;

  void addCellStyles( TQDomDocument & doc, TQDomElement & autoStyles );
  void addColumnStyles( TQDomDocument & doc, TQDomElement & autoStyles );
  void addNumberStyles( TQDomDocument & doc, TQDomElement & autoStyles );
  void addRowStyles( TQDomDocument & doc, TQDomElement & autoStyles );
  void addSheetStyles( TQDomDocument & doc, TQDomElement & autoStyles );
};



#endif
