/*
 * This file is part of Chalk
 *
 * Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Ported from the CImg Gimp plugin by Victor Stinner and David Tschumperlé.
 */
#include "tqlayout.h"
#include "tqcheckbox.h"
#include "tqpushbutton.h"

#include "knuminput.h"

#include "wdg_cimg.h"
#include "kis_cimgconfig_widget.h"
#include "kis_cimg_filter.h"

KisCImgconfigWidget::KisCImgconfigWidget(KisFilter* nfilter, TQWidget * parent, const char * name, WFlags f)
    : KisFilterConfigWidget(parent, name, f)
{
    m_page = new WdgCImg(this);
    TQ_CHECK_PTR(m_page);

    TQHBoxLayout * l = new TQHBoxLayout(this);
    TQ_CHECK_PTR(l);

    l->add(m_page);
    nfilter->setAutoUpdate(false);
    
//     connect(  m_page->bnRefresh, TQ_SIGNAL(clicked()), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numDetail, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numGradient, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numTimeStep, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numBlur, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numBlurIterations, TQ_SIGNAL(valueChanged (int)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numAngularStep, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numIntegralStep, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->numGaussian, TQ_SIGNAL(valueChanged (double)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->chkLinearInterpolation, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(sigPleaseUpdatePreview()));
    connect( m_page->chkNormalize, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(sigPleaseUpdatePreview()));
}


KisCImgFilterConfiguration * KisCImgconfigWidget::config()
{
    KisCImgFilterConfiguration * cfg = new KisCImgFilterConfiguration();
    TQ_CHECK_PTR(cfg);

    cfg->power1         = m_page->numDetail->value();
    cfg->power2         = m_page->numGradient->value();
    cfg->dt             = m_page->numTimeStep->value();
    cfg->sigma          = m_page->numBlur->value();
    cfg->nb_iter        = m_page->numBlurIterations->value();
    cfg->dtheta         = m_page->numAngularStep->value();
    cfg->dlength        = m_page->numIntegralStep->value();
    cfg->gauss_prec     = m_page->numGaussian->value();
    cfg->linear         = m_page->chkLinearInterpolation->isChecked();
    cfg->onormalize     = m_page->chkNormalize->isChecked();

    return cfg;

}

void KisCImgconfigWidget::setConfiguration(KisFilterConfiguration * config)
{
    KisCImgFilterConfiguration * cfg = dynamic_cast<KisCImgFilterConfiguration*>(config);
    if (!cfg) return;

    m_page->numDetail->setValue(cfg->power1);
    m_page->numGradient->setValue(cfg->power2);
    m_page->numTimeStep->setValue(cfg->dt);
    m_page->numBlur->setValue(cfg->sigma);
    m_page->numAngularStep->setValue(cfg->nb_iter);
    m_page->numIntegralStep->setValue(cfg->dlength);
    m_page->numGaussian->setValue(cfg->gauss_prec);
    m_page->chkLinearInterpolation->setChecked(cfg->linear);
    m_page->chkNormalize->setChecked(cfg->onormalize);
}

#include "kis_cimgconfig_widget.moc"
