#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "KDChartAxisParamsWrapper.h"
#include <KDChartAxisParams.h>

KDChartAxisParamsWrapper::KDChartAxisParamsWrapper( KDChartAxisParams* data ) :TQObject(0), _data(data)
{
}

void KDChartAxisParamsWrapper::setAxisValueStart( double axisValueStart )
{
    _data->setAxisValueStart( axisValueStart );
}

void KDChartAxisParamsWrapper::setAxisValueEnd( double axisValueEnd )
{
    _data->setAxisValueEnd( axisValueEnd);
}

void KDChartAxisParamsWrapper::setAxisValueStart( const TQVariant axisValueStart )
{
    _data->setAxisValueStart( axisValueStart );
}

void KDChartAxisParamsWrapper::setAxisValueEnd( const TQVariant axisValueEnd )
{
    _data->setAxisValueEnd( axisValueEnd );
}

void KDChartAxisParamsWrapper::setAxisValues( bool axisSteadyValueCalc,
                                              TQVariant axisValueStart,
                                              TQVariant axisValueEnd,
                                              double axisValueDelta,
                                              int axisDigitsBehindComma,
                                              int axisMaxEmptyInnerSpan,
                                              int takeLabelsFromDataRow,
                                              int labelTextsDataRow,
                                              const TQVariant& axisLabelStringList,
                                              const TQVariant& axisShortLabelsStringList,
                                              int axisValueLeaveOut,
                                              int axisValueDeltaScale )
{
    TQStringList l1 = axisLabelStringList.toStringList();
    TQStringList l2 = axisShortLabelsStringList.toStringList();
    _data->setAxisValues( axisSteadyValueCalc,
                          axisValueStart,
                          axisValueEnd,
                          axisValueDelta,
                          axisDigitsBehindComma,
                          axisMaxEmptyInnerSpan,
                          (KDChartAxisParams::LabelsFromDataRow) takeLabelsFromDataRow,
                          labelTextsDataRow,
                          &l1,
                          &l2,
                          axisValueLeaveOut,
                          (KDChartAxisParams::ValueScale) axisValueDeltaScale );
}

void KDChartAxisParamsWrapper::setAxisLabelStringLists( const TQVariant& axisLabelStringList,
                                                        const TQVariant& axisShortLabelStringList,
                                                        const TQString& valueStart,
                                                        const TQString& valueEnd )
{
    TQStringList l1 = axisLabelStringList.toStringList();
    TQStringList l2 = axisShortLabelStringList.toStringList();
    _data->setAxisLabelStringLists( &l1, &l2, valueStart, valueEnd );
}

void KDChartAxisParamsWrapper::setAxisLabelTexts( const TQVariant& axisLabelTexts )
{
    TQStringList l = axisLabelTexts.toStringList();
    _data->setAxisLabelTexts( &l );
}

#include "KDChartAxisParamsWrapper.moc"
