/***************************************************************************
                          knewfiledlg.h
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNEWFILEDLG_H
#define KNEWFILEDLG_H

// ----------------------------------------------------------------------------
// TQt Includes
#include <tqdialog.h>

// ----------------------------------------------------------------------------
// TDE Includes
#include <tdelocale.h>

// ----------------------------------------------------------------------------
// Project Includes
#include "../dialogs/knewfiledlgdecl.h"

// This dialog lets the user create/edit a file.
// Use the second constructor to edit a file.
class KNewFileDlg : public KNewFileDlgDecl  {
   TQ_OBJECT
  
public:
  KNewFileDlg(TQWidget *parent=0, const char *name=0, const TQString& title=TQString());
  KNewFileDlg(TQString userName, TQString userStreet,
    TQString userTown, TQString userCounty, TQString userPostcode, TQString userTelephone,
    TQString userEmail, TQWidget *parent=0, const char *name=0, const TQString& title=TQString());
  ~KNewFileDlg();

  KPushButton* cancelButton(void) { return cancelBtn; };

public:
  TQString userNameText;
  TQString userStreetText;
  TQString userTownText;
  TQString userCountyText;
  TQString userPostcodeText;
  TQString userTelephoneText;
  TQString userEmailText;

protected:
  /// helper method for constructors
  void init(const TQString& title);

protected slots:
  void okClicked();
  void loadFromKABC(void);
};

#endif
