/***************************************************************************
    begin                : Wed Aug 14 2002
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                :

from Kate (C) 2001 by Matt Newell

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// 2007-03-12 dani
//  - use KileDocument::Extensions

#include "kilefileselect.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqstrlist.h>
#include <tqtooltip.h>

#include <tdetoolbar.h>
#include <kiconloader.h>
#include <kprotocolinfo.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <kcharsets.h>
#include "kiledebug.h"

#include "kileconfig.h"

KileFileSelect::KileFileSelect(KileDocument::Extensions *extensions, TQWidget *parent, const char *name ) : TQWidget(parent,name)
{
  TQVBoxLayout* lo = new TQVBoxLayout(this);

  TDEToolBar *toolbar = new TDEToolBar(this, "fileselectortoolbar");
  lo->addWidget(toolbar);

  cmbPath = new KURLComboBox( KURLComboBox::Directories, true, this, "path combo" );
  cmbPath->setSizePolicy( TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
  cmpl = new KURLCompletion(KURLCompletion::DirCompletion);
  cmbPath->setCompletionObject( cmpl );
  lo->addWidget(cmbPath);

  dir = new KDirOperator(KURL(), this, "operator");
  connect(dir, TQ_SIGNAL(fileSelected(const KFileItem*)), this, TQ_SIGNAL(fileSelected(const KFileItem*)));
  dir->setView(KFile::Simple);
  dir->setMode(KFile::Files);

	// KileFileSelect filter for sidebar 
	TQString filter =  extensions->latexDocuments() 
	                    + ' ' + extensions->latexPackages() 
	                    + ' ' + extensions->bibtex() 
	                    + ' ' +  extensions->metapost();
	filter.replace(".","*.");
	dir->setNameFilter(filter);

  TDEActionCollection *coll = dir->actionCollection();
  // some shortcuts of diroperator that clashes with Kate
  coll->action( "delete" )->setShortcut( TDEShortcut( ALT + Key_Delete ) );
  coll->action( "reload" )->setShortcut( TDEShortcut( ALT + Key_F5 ) );
  coll->action( "back" )->setShortcut( TDEShortcut( ALT + SHIFT + Key_Left ) );
  coll->action( "forward" )->setShortcut( TDEShortcut( ALT + SHIFT + Key_Right ) );
  // some consistency - reset up for dir too
  coll->action( "up" )->setShortcut( TDEShortcut( ALT + SHIFT + Key_Up ) );
  coll->action( "home" )->setShortcut( TDEShortcut( CTRL + ALT + Key_Home ) );

  coll->action("home")->plug(toolbar);
  coll->action("up")->plug(toolbar);
  coll->action("back")->plug(toolbar);
  coll->action("forward")->plug(toolbar);

  toolbar->insertButton("document-open", 0, true , i18n( "Open selected" ));
  connect(toolbar, TQ_SIGNAL(clicked(int)), this, TQ_SLOT(clickedToolbar(int)));

  lo->addWidget(dir);
  lo->setStretchFactor(dir, 2);

  m_comboEncoding = new KComboBox( false, this, "comboEncoding" );
  TQStringList availableEncodingNames(TDEGlobal::charsets()->availableEncodingNames());
  m_comboEncoding->setEditable( true );
  m_comboEncoding->insertStringList( availableEncodingNames );
  TQToolTip::add(m_comboEncoding, i18n("Set encoding"));
  lo->addWidget(m_comboEncoding);

  connect( cmbPath, TQ_SIGNAL( urlActivated( const KURL&  )),this,  TQ_SLOT( cmbPathActivated( const KURL& ) ));
  connect( cmbPath, TQ_SIGNAL( returnPressed( const TQString&  )), this,  TQ_SLOT( cmbPathReturnPressed( const TQString& ) ));
  connect(dir, TQ_SIGNAL(urlEntered(const KURL&)), this, TQ_SLOT(dirUrlEntered(const KURL&)) );
}

KileFileSelect::~KileFileSelect()
{
  delete cmpl;
}

void KileFileSelect::readConfig()
{
	TQString lastDir = KileConfig::lastDir();
	TQFileInfo ldi(lastDir);
	if ( ! ldi.isReadable() ) dir->home();
	else setDir(KURL::fromPathOrURL(lastDir));
}

void KileFileSelect::writeConfig()
{
	KileConfig::setLastDir(dir->url().path());
}

void KileFileSelect::setView(KFile::FileView view)
{
 dir->setView(view);
}

void KileFileSelect::cmbPathActivated( const KURL& u )
{
   dir->setURL( u, true );
}

void KileFileSelect::cmbPathReturnPressed( const TQString& u )
{
   dir->setFocus();
   dir->setURL( KURL(u), true );
}

void KileFileSelect::dirUrlEntered( const KURL& u )
{
   cmbPath->removeURL( u );
   TQStringList urls = cmbPath->urls();
   urls.prepend( u.url() );
   while ( urls.count() >= (uint)cmbPath->maxItems() )
      urls.remove( urls.last() );
   cmbPath->setURLs( urls );
}

void KileFileSelect::focusInEvent(TQFocusEvent*)
{
   dir->setFocus();
}

void KileFileSelect::setDir( KURL u )
{
  dir->setURL(u, true);
}

void KileFileSelect::clickedToolbar(int i)
{
	if (i == 0)
	{
		TQPtrListIterator<KFileItem> it(*dir->selectedItems());
		while (  it.current() != 0 )
		{
			emit(fileSelected(*it));
        	++it;
		}

		dir->view()->clearSelection();
	}
}

#include "kilefileselect.moc"
