/***************************************************************************
                          errorlog-interfaces.h  -  description
                             -------------------
    begin                : Sa Sep 13 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_ERRORLOG_INTERFACES_H
#define KRADIO_ERRORLOG_INTERFACES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "interfaces.h"

INTERFACE(IErrorLog, IErrorLogClient)
{
public :
    IErrorLog();
    virtual ~IErrorLog();

RECEIVERS:
    IF_RECEIVER(    logError  (const TQString &)         )
    IF_RECEIVER(    logWarning(const TQString &)         )
    IF_RECEIVER(    logInfo   (const TQString &)         )
    IF_RECEIVER(    logDebug  (const TQString &)         )
};


INTERFACE(IErrorLogClient, IErrorLog)
{
public :
    IF_CON_DESTRUCTOR(IErrorLogClient, -1)

public:
    IF_SENDER  (    sendLogError  (const TQString &)     )
    IF_SENDER  (    sendLogWarning(const TQString &)     )
    IF_SENDER  (    sendLogInfo   (const TQString &)     )
    IF_SENDER  (    sendLogDebug  (const TQString &)     )

    void logError  (const TQString &s) const { sendLogError(s);   }
    void logWarning(const TQString &s) const { sendLogWarning(s); }
    void logInfo   (const TQString &s) const { sendLogInfo(s);    }
    void logDebug  (const TQString &s) const { sendLogDebug(s);   }

    static void staticLogError  (const TQString &s);
    static void staticLogWarning(const TQString &s);
    static void staticLogInfo   (const TQString &s);
    static void staticLogDebug  (const TQString &s);
};


#endif
