/***************************************************************************
                          kmplayer.h  -  description
                             -------------------
    begin                : Sat Dec  7 16:14:51 CET 2002
    copyright            : (C) 2002 by Koos Vriezen
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMPLAYER_H
#define KMPLAYER_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tdeaccel.h>
#include <tdeaction.h>
#include <kurl.h>
#include "kmplayerplaylist.h"

static const int id_status_msg = 1;
static const int id_status_timer = 2;

class TQPopupMenu;
class TQMenuItem;
class TQListViewItem;
class TDEProcess;
class KMPlayerBroadcastConfig;
class KMPlayerFFServerConfig;
class KSystemTray;

namespace KMPlayer {
    class View;
    class PartBase;
    class Source;
    class KMPlayerDVDSource;
    class KMPlayerDVDNavSource;
    class KMPlayerVCDSource;
    class KMPlayerPipeSource;
    class KMPlayerTVSource;
    class FFMpeg;
    class PlayListItem;
} // namespace


class KMPlayerApp : public TDEMainWindow
{
    TQ_OBJECT
  

public:
    KMPlayerApp (TQWidget* parent=0, const char* name=0);
    ~KMPlayerApp ();
    void openDocumentFile (const KURL& url=KURL());
    void addURL (const KURL& url);
    KMPlayer::PartBase * player () const { return m_player; }
    void resizePlayer (int percentage);
    TDE_NO_EXPORT TDERecentFilesAction * recentFiles () const { return fileOpenRecent; }
    TDE_NO_EXPORT KMPlayer::View *view () const { return m_view; }
    bool broadcasting () const;
    void showBroadcastConfig ();
    void hideBroadcastConfig ();
    TDE_NO_EXPORT KMPlayerBroadcastConfig * broadcastConfig () const { return m_broadcastconfig; }
    /* After createGUI() some menu's have to readded again */
    void initMenu ();
    void restoreFromConfig ();
protected:
    void saveOptions ();
    void readOptions ();
    void saveProperties (TDEConfig * config);
    void readProperties (TDEConfig * config);
    void initActions ();
    void initStatusBar ();
    void initView ();
    virtual bool queryClose ();
    virtual bool queryExit ();

public slots:
    void slotFileNewWindow ();
    void slotFileOpen ();
    void slotFileOpenRecent (const KURL& url);
    void slotSaveAs ();
    void slotFileClose ();
    void slotFileQuit ();
    void slotPreferences ();
    void slotViewToolBar ();
    void slotViewStatusBar ();
    void slotViewMenuBar ();
    void slotStatusMsg (const TQString &text);
    void slotSourceChanged (KMPlayer::Source *, KMPlayer::Source *);
private slots:
    void dvdNav ();
    void openDVD ();
    void openVCD ();
    void openAudioCD ();
    void openPipe ();
    void openVDR ();
    void fullScreen ();
    void configChanged ();
    void keepSizeRatio ();
    void startArtsControl();
    void loadingProgress (int percentage);
    void positioned (int pos, int length);
    void zoom50 ();
    void zoom100 ();
    void zoom150 ();
    void zoom200 ();
    void zoom300 ();
    void editMode ();
    void syncEditMode ();
    void broadcastClicked ();
    void broadcastStarted ();
    void broadcastStopped ();
    void playerStarted ();
    void slotMinimalMode ();
    void slotConfigureKeys();
    void slotConfigureToolbars ();
    void slotClearHistory ();
    void windowVideoConsoleToggled (int wt);
    void playListItemSelected (TQListViewItem *);
    void playListItemDropped (TQDropEvent * e, TQListViewItem * after);
    void playListItemMoved ();
    void menuDropInList ();
    void menuDropInGroup ();
    void menuCopyDrop ();
    void menuDeleteNode ();
    void menuMoveUpNode ();
    void menuMoveDownNode ();
    void preparePlaylistMenu (KMPlayer::PlayListItem *, TQPopupMenu *);
    void slotFakeKeyEvent();

private:
    void menuItemClicked (TQPopupMenu * menu, int id);
    void minimalMode (bool deco=true);
    TDEConfig * config;
    KSystemTray * m_systray;
    KMPlayer::PartBase * m_player;
    KMPlayer::View * m_view;
    KMPlayer::NodePtr recents;
    KMPlayer::NodePtr playlist;
    KMPlayer::NodePtrW manip_node;

    TDEAction * fileNewWindow;
    TDEAction * fileOpen;
    TDERecentFilesAction * fileOpenRecent;
    TDEAction * fileClose;
    TDEAction * fileQuit;
    TDEAction * editVolumeInc;
    TDEAction * editVolumeDec;
    TDEAction * toggleView;
    TDEAction * viewSyncEditMode;
#if KDE_IS_VERSION(3,1,90)
    TDEToggleAction * viewFullscreen;
#else
    TDEAction * viewFullscreen;
#endif
    TDEToggleAction * viewEditMode;
    TDEToggleAction * viewToolBar;
    TDEToggleAction * viewStatusBar;
    TDEToggleAction * viewMenuBar;
    TDEToggleAction * viewKeepRatio;
    TQMenuItem * m_sourcemenu;
    TQPopupMenu * m_dvdmenu;
    TQPopupMenu * m_dvdnavmenu;
    TQPopupMenu * m_vcdmenu;
    TQPopupMenu * m_audiocdmenu;
    TQPopupMenu * m_tvmenu;
    TQPopupMenu * m_dropmenu;
    KMPlayerFFServerConfig * m_ffserverconfig;
    KMPlayerBroadcastConfig * m_broadcastconfig;
    TQCString m_dcopName;
    KURL::List m_drop_list;
    TQListViewItem * m_drop_after;
    int edit_tree_id;
    int manip_tree_id;
    int last_time_left;
    int recents_id;
    int playlist_id;
    bool m_showToolbar;
    bool m_showStatusbar;
    bool m_showMenubar;
    bool m_played_intro;
    bool m_played_exit;
    bool m_minimal_mode;
    bool m_auto_resize;

    TQTimer m_screensaverTimer;
    bool m_haveKWin;
    bool haveXTest;
    int fakeKeycode;
};

class KMPLAYER_NO_EXPORT FileDocument : public KMPlayer::Document {
public:
    FileDocument (short id, const TQString &, KMPlayer::PlayListNotify * notify = 0L);
    KMPlayer::NodePtr childFromTag (const TQString & tag);
    void readFromFile (const TQString & file);
    void writeToFile (const TQString & file);
};

#endif // KMPLAYER_H
