/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "propertiesdialog.h"
#include <tdelocale.h>
#include <kdialog.h>
#include <tdemessagebox.h>
#include <tdeconfig.h>

#include "backends/recipedb.h"
#include "createpropertydialog.h"
#include "widgets/propertylistview.h"

PropertiesDialog::PropertiesDialog( TQWidget *parent, RecipeDB *db ) : TQWidget( parent )
{

	// Store pointer to database
	database = db;

	// Design dialog

	TQHBoxLayout* layout = new TQHBoxLayout( this, KDialog::marginHint(), KDialog::spacingHint() );

	propertyListView = new CheckPropertyListView( this, database, true );
	propertyListView->reload();

	TDEConfig *config = TDEGlobal::config();
	config->setGroup("Formatting");
	TQStringList hiddenList = config->readListEntry("HiddenProperties");
	for ( TQCheckListItem *item = (TQCheckListItem*)propertyListView->firstChild(); item; item = (TQCheckListItem*)item->nextSibling() ) {
		if ( !hiddenList.contains(item->text(0)) )
			item->setOn(true);
	}

	layout->addWidget ( propertyListView );

	TQVBoxLayout* vboxl = new TQVBoxLayout( KDialog::spacingHint() );
	addPropertyButton = new TQPushButton( this );
	addPropertyButton->setText( i18n( "Create ..." ) );
	addPropertyButton->setFlat( true );
	vboxl->addWidget( addPropertyButton );
	removePropertyButton = new TQPushButton( this );
	removePropertyButton->setText( i18n( "Delete" ) );
	removePropertyButton->setFlat( true );
	vboxl->addWidget( removePropertyButton );
	vboxl->addStretch();
	layout->addLayout( vboxl );

	// Connect signals & slots
	connect( addPropertyButton, TQ_SIGNAL( clicked() ), propertyListView, TQ_SLOT( createNew() ) );
	connect( removePropertyButton, TQ_SIGNAL( clicked() ), propertyListView, TQ_SLOT( remove
		         () ) );

	//FIXME: We've got some sort of build issue... we get undefined references to CreatePropertyDialog without this dummy code here
	UnitList list;
	CreatePropertyDialog d( this, &list );
}


PropertiesDialog::~PropertiesDialog()
{}

void PropertiesDialog::reload( void )
{
	propertyListView->reload();
}

#include "propertiesdialog.moc"
