/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-04-21
 * Description : slide show tool using preview of pictures.
 * 
 * Copyright (C) 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SLIDE_SHOW_H
#define SLIDE_SHOW_H

// TQt includes.

#include <tqwidget.h>

// Local includes.

#include "digikam_export.h"
#include "loadingdescription.h"
#include "slideshowsettings.h"

namespace Digikam
{

class DImg;
class SlideShowPriv;

class DIGIKAM_EXPORT SlideShow : public TQWidget
{
    TQ_OBJECT
  

public:

    SlideShow(const SlideShowSettings& settings);
    ~SlideShow();

    void setCurrent(const KURL& url);

protected:

    void paintEvent(TQPaintEvent *);
    void mousePressEvent(TQMouseEvent *);
    void mouseMoveEvent(TQMouseEvent *);
    void keyPressEvent(TQKeyEvent *);
    void wheelEvent(TQWheelEvent *);

private slots:

    void slotTimeOut();
    void slotMouseMoveTimeOut();
    void slotGotImagePreview(const LoadingDescription &, const DImg &);

    void slotPause();
    void slotPlay();
    void slotPrev();
    void slotNext();
    void slotClose();

private:

    void loadNextImage();
    void loadPrevImage();
    void preloadNextImage();
    void updatePixmap();
    void printInfoText(TQPainter &p, int &offset, const TQString& str);
    void printComments(TQPainter &p, int &offset, const TQString& comments);

private:

    SlideShowPriv *d;
};

}  // NameSpace Digikam

#endif /* SLIDE_SHOW_H */
