/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-06-05
 * Description : TQSlite DB interface.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef SQLITEDB_H
#define SQLITEDB_H

// TQt includes.

#include <tqstring.h>

class TQStringList;

class SqliteDB
{

public:

    SqliteDB();
    ~SqliteDB();

    void openDB(const TQString& directory);
    void closeDB();

    bool execSql(const TQString& sql, TQStringList* const values = 0,
                 TQString* const errMsg = 0, bool debug = false) const;

    TQ_LLONG lastInsertedRow() const;
    
    void    setSetting( const TQString& keyword, const TQString& value );
    TQString getSetting( const TQString& keyword );

private:

    mutable struct sqlite3* m_db;
};

extern TQString escapeString(const TQString& str);

#endif /* SQLITEDB_H */
