// Author: Denis Kozadaev - (c) 2017-2020


#include "mainwindow.h"

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>


const int XSize = 640, YSize = 640;
static const char description[] = I18N_NOOP(
"A knight's tour is a sequence of moves of a knight on a chessboard "
"such that the knight visits every square exactly once.");


int main(int argc, char *argv[])
{
	TDEApplication	*app;
	MainWindow	*mainWin;
	int		retcode;
	TDEAboutData	about(
	"knighttour",			// program name used internally
	I18N_NOOP("Knight's tour"),	// displayable program name
	"14.0.10",			// program version string
	description,			// short description
	TDEAboutData::License_GPL,	// licence type
	I18N_NOOP("(c) 2025 Denis Kozadaev"),	// copyright statement
	nullptr,			// text - any information
	"http://trinitydesktop.org",	// home page address
	nullptr);			// bug email address

	about.addAuthor("Denis Kozadaev", "Author", "denis@tambov.ru");

	TDECmdLineArgs::init(argc, argv, &about);

	app = new TDEApplication();

	mainWin = new MainWindow();

	mainWin->resize(XSize, YSize);
	mainWin->setMinimumSize( mainWin->size() );
	mainWin->setMaximumSize( mainWin->size() );

	app->setMainWidget( mainWin );
	app->miniIcon();
	mainWin->show();

	retcode = app->exec();

	delete app;

	return (retcode);
}
