/***************************************************************************
                          command.cpp  -  description
                             -------------------
    begin                : Sun Jun 30 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "command.h"

Command::Command( int ID, int Command, int WhiteTime, int BlackTime, struct ChessMove Move )
{
  white_time = WhiteTime;
  black_time = BlackTime;
  move = Move;
	id = ID;
  command = Command;
}

Command::Command( int ID, int Command, int WhiteTime, int BlackTime, struct ChessMove Move, TQString Data )
{
  white_time = WhiteTime;
  black_time = BlackTime;
  data = Data;
  move = Move;
	id = ID;
  command = Command;
}

Command::Command( int ID, int Command, int WhiteTime, int BlackTime, TQString Data )
{
  white_time = WhiteTime;
  black_time = BlackTime;
  data = Data;
	id = ID;
  command = Command;
}

Command::Command( int ID, int Command )
{
	clear();
	id = ID;
	command = Command;
}

Command::Command( int ID, int Command, TQString Data )
{
	clear();
	id = ID;
	command = Command;
	data = Data;
}

Command::Command()
{
	clear();
}

Command::~Command()
{
}

void Command::clear(void)
{
	white_time = 0;
	black_time = 0;
	command = CMD_None;
	clearMove( &move );
}
///////////////////////////////////////
//
//	Command::clearMove
//
///////////////////////////////////////
void Command::clearMove( ChessMove *Move )
{
	Move->fromFile = Null;
	Move->fromRank = Null;
	Move->toFile = Null;
	Move->toRank = Null;
	Move->Promote = Null;
	Move->ManTaken = Null;
	Move->NAG = 0;
	Move->ICS_MoveCounter = 0;
	Move->ICS_PawnPushFile = Null;
	Move->ICS_Mode = Null;
	Move->ICS_OnMove = 0;
	Move->ICS_ClockTicking = true;
}
