/***************************************************************************
                          showlistviewitem.h  -  description
                             -------------------
    begin                : Son Apr 21 2002
    copyright            : (C) 2002 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SHOWLISTVIEWITEM_H
#define SHOWLISTVIEWITEM_H

#include <tqlistview.h>

/**
  *@author Eggert Ehmke
  */

class ShowListViewItem : public TQListViewItem
{
public:

  /**
   * Constructor
   * @param parent mail list view
   * @param after insert the new item after this item
   */
  ShowListViewItem (TQListView * parent, ShowListViewItem * after);

  /**
   * Constructor
   * @param parent mail list view
   */
  ShowListViewItem( TQListView* parent );


  virtual	~ShowListViewItem();
  virtual TQString key (int column, bool ascending) const;
  /**
    * reimplement compare to solve bug #856005
    * standard compare is locale dependant
    */
  virtual int compare( TQListViewItem *i, int col, bool ascending ) const;
  void setNumber (const TQString&);
  void setAccount(const TQString&);
  void setFrom(const TQString&);
  void setTo(const TQString&);
  void setSubject(const TQString&);
  void setDate(const TQString&);
  void setSize(const TQString&);
  void setContent(const TQString&);
  void setState(const TQString&);
  void setTime (const TQString&);
  enum {_colNumber, _colAccount, _colFrom, _colTo, _colSubject, _colDate,
        _colSize, _colContent, _colState};
private:
	TQString m_time;
};


#endif
