/***************************************************************************
 *
 * tdenetman-vpnservice.cpp - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#define SERVICE_DIR "/etc/NetworkManager/VPN"

#include <stdlib.h>
#include <tdeconfig.h>
#include <tqdom.h> 
#include <tqdir.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kprocess.h>
#include <tdeconfig.h>
#include <kplugininfo.h>

#include "tdenetman-pluginmanager.h"
#include "tdenetman-vpnservice.h"
#include "tdenetman-vpnplugin.h"

/*
 *  class VPNService
 *
 */

VPNService::VPNService(const TQString& serviceName, const TQString& service, TQObject* parent, const char* name)
	: TQObject(parent, name)
{
	_name = serviceName;
	_service = service;
	_vpnPlugin = NULL;

	// query if a plugin for this vpn service is available
	PluginManager* plugMan = PluginManager::getInstance();
	if (plugMan) {
		TQStringList list = plugMan->getPluginList("TDENetworkManager/VPNPlugin", "X-NetworkManager-Services", serviceName);
		if (list.size() > 0) {
			// get the first VPN Plugin handling our VPNService
			VPNPlugin* vpnPlugin = dynamic_cast<VPNPlugin*>( plugMan->getPlugin(list.first()) );
			if (vpnPlugin)
			{
				kdDebug() << k_funcinfo << i18n("Using VPN plugin '%1' for service '%2'").arg(list.first()).arg(serviceName) << endl;
				_vpnPlugin = vpnPlugin;
			}
		}
	}
}

VPNService::~VPNService()
{

}

TQString VPNService::getIcon()
{
	if (!_vpnPlugin.isNull())
	{
		PluginManager* plugMan = PluginManager::getInstance();
		if (plugMan)
		{
			const KPluginInfo* info = plugMan->getPluginInfo(_vpnPlugin);
			if (info)
			{
				TQString icon = info->icon();
				if (!icon.isEmpty())
					return icon;
			}
		}
	}
	return "encrypted";
}

VPNPlugin* VPNService::getVPNPlugin()
{
	return _vpnPlugin;
}

TQString VPNService::getService() const
{
	return _service;
}

TQString VPNService::getDisplayName() const
{
	const KPluginInfo* info = NULL;
	PluginManager* plugMan = PluginManager::getInstance();
	if (_vpnPlugin && plugMan)
		if ( (info = plugMan->getPluginInfo(_vpnPlugin)) )
			if (!info->name().isEmpty())
				return info->name();
	return _name;
}

TQString VPNService::getName() const
{
	return _name;
}

#include "tdenetman-vpnservice.moc"
