/* 
 * Port for usage with tqt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

#ifndef _SVNCPP_CONTEXT_HPP_
#define _SVNCPP_CONTEXT_HPP_

#include "svnqt/svnqt_defines.h"

// tqt
#include <tqstring.h>

// Subversion api
#include "svn_client.h"

// svncpp
#include "svnqt/pool.h"
#include "svnqt/smart_pointer.h"


namespace svn
{
  // forward declarations
  class ContextListener;
  class ContextData;

  /**
   * This class will hold the client context
   * and replace the old notification and baton
   * stuff
   */
  class SVNTQT_EXPORT Context:public ref_count
  {
  public:
    /**
     * default constructor
     *
     * @param configDir location where the
     *                  subversion api stores its
     *                  configuration
     */
    Context (const TQString & configDir=TQString());

    /**
     * copy constructor
     *
     * @param src
     */
    Context (const Context &src);

    /**
     * destructor
     */
    virtual ~Context ();

    /**
     * enable/disable authentication caching
     *
     * @param value true=enable/false=disable
     */
    void setAuthCache (bool value);

    /**
     * set username/password for authentication
     */
    void setLogin (const TQString& username, const TQString& password);

    /**
     * operator to get svn_client_ctx object
     */
    operator svn_client_ctx_t * ();

    /**
     * return the svn_client_ctx object
     */
    svn_client_ctx_t * ctx ();

    /**
     * this will be called at the beginning of an action.
     * the log message will be reset.
     */
    void reset ();

    /**
     * set log message
     *
     * @param msg
     */
    void setLogMessage (const TQString& msg);

    /**
     * get log message
     *
     * @return log message
     */
    const TQString&
    getLogMessage () const;

    /**
     * get username
     *
     * @return username
     */
    const TQString&
    getUsername () const;

    /**
     * get password
     *
     * @return password
     */
    const TQString&
    getPassword () const;

    /**
     * set the listener for the context. The listener will be
     * called to poll authentication information and other
     * information like this
     *
     * @param listener
     */
    void
    setListener (ContextListener * listener);

    /**
     * get the listener
     *
     * @return the listener
     */
    ContextListener *
    getListener () const;

  private:
    ContextData * m;

    /**
     * disable assignment operator
     */
    Context & operator = (const Context &);
  };

  typedef svn::smart_pointer<svn::Context> ContextP;
}

#endif
