/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "revtreewidget.h"
#include "tdesvnsettings.h"

#include <tqvariant.h>
#include <tqsplitter.h>
#include <ktextbrowser.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include "revgraphview.h"
#include "ktextbrowser.h"

/*
 *  Constructs a RevTreeWidget as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
RevTreeWidget::RevTreeWidget(TQObject*lt,svn::Client*cl, TQWidget* parent, const char* name, WFlags fl )
    : TQWidget( parent, name, fl )
{
    if ( !name )
        setName( "RevTreeWidget" );
    RevTreeWidgetLayout = new TQVBoxLayout( this, 11, 6, "RevTreeWidgetLayout");

    m_Splitter = new TQSplitter( this, "m_Splitter" );
    m_Splitter->setOrientation( TQt::Vertical );

    m_RevGraphView = new RevGraphView(lt,cl, m_Splitter, "m_RevGraphView" );
    m_RevGraphView->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)5, (TQSizePolicy::SizeType)5, 0, 2, m_RevGraphView->sizePolicy().hasHeightForWidth() ) );
    connect(m_RevGraphView,TQ_SIGNAL(dispDetails(const TQString&)),this,TQ_SLOT(setDetailText(const TQString&)));
    connect(m_RevGraphView,
                    TQ_SIGNAL(makeNorecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*)),
                    this,
                    TQ_SIGNAL(makeNorecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*))
           );
    connect(m_RevGraphView,
            TQ_SIGNAL(makeRecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*)),
            this,
            TQ_SIGNAL(makeRecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*))
           );
    connect(m_RevGraphView,
            TQ_SIGNAL(makeCat(const svn::Revision&,const TQString&,const TQString&,const svn::Revision&,TQWidget*)),
            this,
            TQ_SIGNAL(makeCat(const svn::Revision&,const TQString&,const TQString&,const svn::Revision&,TQWidget*))
           );

    m_Detailstext = new KTextBrowser( m_Splitter, "m_Detailstext" );
    m_Detailstext->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)7, (TQSizePolicy::SizeType)7, 0, 0, m_Detailstext->sizePolicy().hasHeightForWidth() ) );
    m_Detailstext->setResizePolicy( KTextBrowser::Manual );
    RevTreeWidgetLayout->addWidget( m_Splitter );
    resize( TQSize(600, 480).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    TQValueList<int> list = Kdesvnsettings::tree_detail_height();
    if (list.count()==2 && (list[0]>0||list[1]>0)) {
        m_Splitter->setSizes(list);
    }
}

/*
 *  Destroys the object and frees any allocated resources
 */
RevTreeWidget::~RevTreeWidget()
{
    // no need to delete child widgets, TQt does it all for us
    TQValueList<int> list = m_Splitter->sizes();
    if (list.count()==2) {
        Kdesvnsettings::setTree_detail_height(list);
        Kdesvnsettings::writeConfig();
    }
}

void RevTreeWidget::setBasePath(const TQString&_p)
{
    m_RevGraphView->setBasePath(_p);
}

void RevTreeWidget::dumpRevtree()
{
    m_RevGraphView->dumpRevtree();
}

void RevTreeWidget::setDetailText(const TQString&_s)
{
    m_Detailstext->setText(_s);
    TQValueList<int> list = m_Splitter->sizes();
    if (list.count()!=2) return;
    if (list[1]==0) {
        int h = height();
        int th = h/10;
        list[0]=h-th;
        list[1]=th;
        m_Splitter->setSizes(list);
    }
}

#include "revtreewidget.moc"

