#ifndef _KVI_INPUT_H_
#define _KVI_INPUT_H_

//=============================================================================
//
//   File : kvi_input.h
//   Creation date : Sun Jan 3 1999 23:04:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"


#include <tqwidget.h>
#include "kvi_tal_hbox.h"
#include <tqpixmap.h>
#include "kvi_pointerlist.h"

#include "kvi_string.h"

//#include <tqdialog.h>
#include <tqtoolbutton.h>

class KviUserListView;
class KviWindow;
class KviInput;
class KviTalHBox;
class TQFontMetrics;

// Default maximum buffer size.
#define KVI_INPUT_MAX_BUFFER_SIZE 400
// Border , better do not touch this
#define KVI_INPUT_BORDER 1
#define KVI_INPUT_MARGIN 2
// Cursor blink time...just don't set it to a value less than 100 if
// you don't want to be lagged by your cursors :)
#define KVI_INPUT_BLINK_TIME 800
// Drag scroll speed...(smaller values = faster)
#define KVI_INPUT_DRAG_TIMEOUT 80
// Maximum entries in the history buffer
#define KVI_INPUT_MAX_HISTORY_ENTRIES 100

class KVIRC_API KviInputHistory
{
public:
	KviInputHistory();
	~KviInputHistory();
protected:
	KviPointerList<TQString> * m_pStringList;
public:
	void add(TQString * s);
	KviPointerList<TQString> * list(){ return m_pStringList; };
	void save(const char * filename);
	void load(const char * filename);
};


class KVIRC_API KviInputEditor : public TQFrame
{
	// friend class KviUserParser;
	//TQ_PROPERTY( int KviProperty_FocusOwner READ heightHint )
	TQ_PROPERTY( int TransparencyCapable READ heightHint )

	TQ_OBJECT
  
public:
	KviInputEditor(TQWidget * par,KviWindow *wnd,KviUserListView * view = 0);
	~KviInputEditor();
protected:

	TQString                  m_szTextBuffer;
	int                      m_iCursorPosition;
	int                      m_iFirstVisibleChar;
	int                      m_iSelectionBegin;
	int                      m_iSelectionEnd;
	int			 m_iMaxBufferSize;
	bool			 m_bSpSlowFlag; // <-- what is this ?

	// members for supporting input methods
	TQString                  m_szIMText;
	int                      m_iIMStart;
	int                      m_iIMLength;
	int                      m_iIMSelectionBegin;
	int                      m_iIMSelectionLength;
	bool                     m_bIMComposing;

	unsigned char            m_iCurFore;
	unsigned char            m_iCurBack;
	bool                     m_bCurBold;
	bool                     m_bCurUnderline;

	int                      m_iBlockLen;
	int                      m_iBlockWidth;
	bool                     m_bControlBlock;

	bool                     m_bCursorOn;

	int                      m_iCursorTimer;
	int                      m_iDragTimer;

	int                      m_iLastCursorXPosition;
	int                      m_iSelectionAnchorChar;

	// History stuff
	KviPointerList<TQString>    * m_pHistory;
	int                      m_iCurHistoryIdx;

	KviStr                   m_szSaveTextBuffer;

	// Nick completion
	KviUserListView        * m_pUserListView;
	TQString                  m_szLastCompletedNick;
	TQString                  m_szLastCompletionBuffer;
	int                      m_iLastCompletionCursorPosition;
	int                      m_iLastCompletionCursorXPosition;
	int                      m_iLastCompletionFirstVisibleChar;
	bool		         m_bLastCompletionFinished;

	bool                     m_bUpdatesEnabled;
	KviStr                   m_szAltKeyCode;
	KviWindow              * m_pKviWindow;
	TQWidget                * m_pInputParent;
	KviTalPopupMenu             * m_pIconMenu;
	bool			 m_bReadOnly;
public:
	int  heightHint() const;
	virtual TQSize  sizeHint() const;
	void setText(const TQString text);
	TQString text() { return m_szTextBuffer; };
	void insertChar(TQChar c);
	void insertText(const TQString &text);
	void applyOptions();
	void setMaxBufferSize(int size) { m_iMaxBufferSize = size; };
	void setReadOnly(bool bReadOnly) {m_bReadOnly=bReadOnly; };
	bool readOnly() {return m_bReadOnly; };
private:
	void replaceWordBeforeCursor(const TQString &word,const TQString &replacement,bool bRepaint = true);
	int replaceSegment(int start, int length, const TQString &string);
	void getWordBeforeCursor(TQString &buffer,bool * bIsFirstWordInLine);
	void runUpToTheFirstVisibleChar();
	void extractNextBlock(int idx,TQFontMetrics & fm,int curXPos,int maxXPos);
	void drawTextBlock(TQPainter *pa,TQFontMetrics & fm,int curXPos,int textBaseline,int idx,int len,bool bSelected=false);
	TQChar getSubstituteChar(unsigned short control_code);
	void moveRightFirstVisibleCharToShowCursor();
	void repaintWithCursorOn();
	void selectOneChar(int pos);
	int  charIndexFromXPosition(int xPos);
	int  xPositionFromCharIndex(TQFontMetrics& fm,int chIdx,bool bContentsCoords=false);
	int  xPositionFromCharIndex(int chIdx,bool bContentsCoords=false);
	void killDragTimer();
	void handleDragSelection();
	void end();
	void home();
	bool hasSelection();
	void moveCursorTo(int idx,bool bRepaint = true);
	void returnPressed(bool bRepaint = true);
	void completion(bool bShift);
	void standardNickCompletion(bool bAddMask,TQString &word,bool bFirstWordInLine);
	void recalcFontMetrics(TQFontMetrics * pFm);
	void internalCursorRight(bool bShift);
	void internalCursorLeft(bool bShift);
public slots:
	void iconPopupActivated(int id);
	void copyToSelection(bool bDonNotCopyToClipboard=true);
	void copyToClipboard();
	void removeSelected();
	void cut();
	void pasteClipboardWithConfirmation();
	void pasteSelectionWithConfirmation();
	void pasteSlow();
	void stopPasteSlow();
	void pasteFile();
	void selectAll();
	void clear();
signals:
	void escapePressed();
	void enterPressed();
protected:
	virtual void drawContents(TQPainter *);
	//virtual void resizeEvent(TQResizeEvent *);
	virtual void timerEvent(TQTimerEvent *e);
	virtual void focusInEvent(TQFocusEvent *);
	virtual void focusOutEvent(TQFocusEvent *);
	virtual void keyPressEvent(TQKeyEvent *e);
	virtual void keyReleaseEvent(TQKeyEvent *e);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void mouseReleaseEvent(TQMouseEvent *);
	virtual void dragEnterEvent(TQDragEnterEvent *e);
	virtual void dropEvent(TQDropEvent *e);
	virtual void imStartEvent(TQIMEvent *e);
	virtual void imComposeEvent(TQIMEvent *e);
	virtual void imEndEvent(TQIMEvent *e);
};

class KviScriptEditor;

class KVIRC_API KviInput : public TQWidget
{
	TQ_OBJECT
  
public:
	KviInput(KviWindow *par,KviUserListView * view = 0);
	~KviInput();
public:
	KviWindow       * m_pWindow;
	KviInputEditor  * m_pInputEditor;
	KviScriptEditor * m_pMultiLineEditor;
	KviTalHBox		* m_pButtonContainer;
	TQToolButton     * m_pMultiEditorButton;
	TQToolButton     * m_pHistoryButton;
	TQToolButton     * m_pIconButton;
	TQToolButton     * m_pCommandlineModeButton;
	TQToolButton     * m_pHideToolsButton;
protected:
//	virtual void resizeEvent(TQResizeEvent * e);
	virtual void focusInEvent(TQFocusEvent * e);
	virtual void setFocusProxy(TQWidget * w);
	virtual void keyPressEvent(TQKeyEvent * e);
public slots:
	void multilineEditorButtonToggled(bool bOn);
	void historyButtonClicked();
	void iconButtonClicked();
	void inputEditorEnterPressed();
	void toggleToolButtons();
public:
	virtual void setFocus();
	void multiLinePaste(const TQString &text);
	bool isUserFriendly() { return m_pCommandlineModeButton->isOn(); };
	void setUserFriendly(bool bSet) { m_pCommandlineModeButton->setOn(bSet); };
	int heightHint() const;
	void setText(const TQString &text);
	void insertChar(char c);
	void insertText(const TQString & text);
	void applyOptions();
	bool isButtonsHidden();
	void setButtonsHidden(bool bHidden);
	//const TQString & text();
	TQString text();
};

#endif //_KVI_INPUT_H_
