#ifndef _KVI_STRINGCONVERSION_H_
#define _KVI_STRINGCONVERSION_H_

//=============================================================================
//
//   File : kvi_stringconversion.h
//   Creation date : Thu Oct 20 2000 13:27:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_pixmap.h"
#include "kvi_msgtype.h"

#include <tqrect.h>
#include <tqcolor.h>
#include <tqfont.h>
#include <tqstringlist.h>
#include <tqstring.h>


namespace KviStringConversion 
{
	extern KVILIB_API void init(const TQString& szGlobalDir,const TQString& szLocalDir);

	extern KVILIB_API void encodePath(TQString& buffer);
	extern KVILIB_API void decodePath(TQString& buffer);

	extern KVILIB_API void encodePath(TQStringList& buffer);
	extern KVILIB_API void decodePath(TQStringList& buffer);

	// bool <-> 
	extern KVILIB_API void toString(const bool bValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,bool &buffer);

	// int <-> TQString
	extern KVILIB_API void toString(const int iValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,int &buffer);

	// uint <-> TQString
	extern KVILIB_API void toString(const unsigned int uValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,unsigned int &buffer);

	// TQRect <-> TQString
	extern KVILIB_API void toString(const TQRect &rValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,TQRect &buffer);

	// TQString <-> TQString (Null conversion)
	extern KVILIB_API void toString(const TQString &szValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,TQString &buffer);

	// KviPixmap <-> TQString
	extern KVILIB_API void toString(const KviPixmap &pValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,KviPixmap &buffer);

	// TQFont <-> TQString
	extern KVILIB_API void toString(const TQFont &fValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,TQFont &buffer);

	// KviMsgType <-> TQString
	extern KVILIB_API void toString(const KviMsgType &mValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,KviMsgType &buffer);

	// TQColor <-> TQString
	extern KVILIB_API void toString(const TQColor &cValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,TQColor &buffer);

	// TQStringList <-> TQString
	extern KVILIB_API void toString(const TQStringList &sValue,TQString &buffer);
	extern KVILIB_API bool fromString(const TQString &szValue,TQStringList &buffer);
};

#endif //!_KVI_STRINGCONVERSION_H_
