/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef __kivio_gui_h__
#define __kivio_gui_h__

class KivioView;
class KivioCanvas;
class KivioPage;
class KivioDoc;
class KivioPainter;
class KivioPaperLayout;
class KivioShell;
class KivioStackBar;
class KivioStencilSpawner;
class KivioStencilSpawnerSet;
class KivioTabBar;
class TTDESelectColorAction;
class StencilBarDockManager;
class KivioArrowHeadAction;

namespace Kivio {
  class ToolController;
  class PluginManager;
  class AddStencilSetDialog;
  class AddStencilTool;
  class ObjectListPalette;
}

class KivioBirdEyePanel;
class KivioLayerPanel;
class KivioProtectionPanel;
class KivioStencilGeometryPanel;

class KoDocumentEntry;
class KoTabBar;

class TDEAction;
class TDEFontAction;
class TDEFontSizeAction;
class TDEToggleAction;

class TDESelectColorAction;
class TDEActionMenu;

class TQStringList;
class TQPushButton;
class TQProgressBar;
class TQScrollBar;
class DCOPObject;
class KoRuler;
class KoZoomHandler;
class KoUnitDoubleSpinBox;
class KStatusBarLabel;
class KoLineWidthAction;
class KoLineStyleAction;
class KoPaletteManager;

#include <tqdom.h>
#include <tqptrlist.h>
#include <tqframe.h>

#include <KoView.h>
#include <KoDocument.h>
#include <KoUnit.h>

#include <koffice_export.h>
using namespace Kivio;

class KIVIO_EXPORT KivioView : public KoView
{
  TQ_OBJECT
  
  friend class KivioCanvas;

  public:
    KivioView( TQWidget *_parent, const char *_name, KivioDoc *_doc );
    ~KivioView();

    virtual DCOPObject* dcopObject();

    KivioCanvas* canvasWidget() const { return m_pCanvas; }
    KivioDoc* doc()const { return m_pDoc; }

    KivioPage* activePage() const;

    void setActiveSpawnerSet( KivioStencilSpawnerSet* );
    KivioStencilSpawnerSet *activeSpawnerSet();

    KoTabBar* tabBar()const { return  m_pTabBar;}
    KoPaletteManager* paletteManager() { return m_pPaletteManager; };
    void updateMenuPage( );

    virtual void setupPrinter(KPrinter&);
    virtual void print(KPrinter&);

    virtual TQWidget* canvas() const;
    virtual int canvasXOffset() const;
    virtual int canvasYOffset() const;

    bool isSnapGuides()const { return m_bSnapGuides; }
    bool isShowGuides()const { return m_bShowGuides; }
    bool isShowRulers()const { return m_bShowRulers; }
    bool isShowPageMargins()const { return m_bShowPageMargins; }

    virtual int leftBorder() const;
    virtual int rightBorder() const;
    virtual int topBorder() const;
    virtual int bottomBorder() const;


    // Returns the current interface color/lineWidth settings
    TQColor fgColor()const;
    TQColor bgColor()const;
    double lineWidth()const;
    int lineStyle() const;
    void updateButton();
    void insertPage( KivioPage* page );
    void resetLayerPanel();
    void updateProtectPanelCheckBox();

    KoZoomHandler* zoomHandler() const;

    KoRuler* horzRuler() const { return hRuler; }
    KoRuler* vertRuler() const { return vRuler; }

    Kivio::PluginManager* pluginManager();

    int hTextAlign();
    int vTextAlign();

  signals:
    void zoomChanged(int);
    void updateStencilSetList();

  protected:
    void createGeometryDock();
    void createLayerDock();
    void createBirdEyeDock();
    void createProtectionDock();
    void createObjectListPalette();

  public slots:
    void paperLayoutDlg();

    void togglePageMargins(bool);
    void toggleShowRulers(bool);
    void toggleShowGrid(bool);
    void toggleSnapGrid(bool);
    void toggleShowGuides(bool);

    void toggleStencilGeometry(bool);
    void toggleViewManager(bool);

    void addPage( KivioPage* );
    void removePage( KivioPage* );
    void insertPage();
    void removePage();
    void renamePage();
    void hidePage();
    void showPage();
    void viewZoom(int);

    void groupStencils();
    void ungroupStencils();

    void selectAllStencils();
    void unselectAllStencils();

    void bringStencilToFront();
    void sendStencilToBack();

    void addStencilFromSpawner( KivioStencilSpawner *pSpawner, double x = 0.0, double y = 0.0 );

    void changePage( const TQString& _name );

    void updateToolBars();

    void cutStencil();
    void copyStencil();
    void pasteStencil();
    /// Called by the delete action
    void deleteObject();

    void alignStencilsDlg();
    void optionsDialog();

    void slotPageHidden( KivioPage* page );
    void slotPageShown( KivioPage* page );

    void setRulerPageLayout(const KoPageLayout& l);

    void popupTabBarMenu( const TQPoint& point );

    void initStatusBarProgress();
    void setStatusBarProgress(int progress);
    void removeStatusBarProgress();

    void setActivePage( KivioPage* );

    void setStatusBarInfo(const TQString& text);

  protected slots:
    void slotPageRenamed( KivioPage* page, const TQString& old_name );
    void slotUpdateView( KivioPage *_page );
    void slotUpdateGrid();

    void setFGColor();
    void setBGColor();
    void setTextColor();

    void setFontFamily( const TQString & );
    void setFontSize( int );

    void setLineWidth(double);
    void setLineStyle(int);

    void toggleFontBold(bool);
    void toggleFontItalics(bool);
    void toggleFontUnderline(bool);

    void setHParaAlign( int );
    void setVParaAlign( int );
    void textAlignLeft();
    void textAlignCenter();
    void textAlignRight();
    void textSuperScript();
    void textSubScript();
    void showAlign( int align );
    void showVAlign( int align );

    void slotSetStartArrow( int );
    void slotSetEndArrow( int );

    void slotSetStartArrowSize();
    void slotSetEndArrowSize();

    void slotChangeStencilPosition(double, double);
    void slotChangeStencilSize(double, double);
    void slotChangeStencilRotation(int);

    void viewZoom(const TQString& s);

    void addSpawnerToStackBar( KivioStencilSpawnerSet * );
    void addStencilSet( const TQString& );

    void setMousePos( int mx, int my );
    void setRulerUnit(KoUnit::Unit);
    void setRulerHOffset(int h);
    void setRulerVOffset(int v);
    void rulerChangedUnit(KoUnit::Unit u);

    void textFormat();
    void stencilFormat();
    void arrowHeadFormat();

    void clipboardDataChanged();

    void installStencilSet();

    /// This slot gets called when the loading has finished (doh!)
    void loadingFinished();

    void moveTab(unsigned tab, unsigned target);

    void addGuideLine();

    void showAddStencilSetDialog();

    void updateRulers();

  protected:
    void setupActions();
    void initActions();

    virtual void updateReadWrite( bool readwrite );
    virtual void partActivateEvent(KParts::PartActivateEvent* event);
    
    void updatePageStatusLabel();

  private:
    KivioCanvas *m_pCanvas;
    KoTabBar *m_pTabBar;

    TDEAction* m_paperLayout;
    TDEAction* m_insertPage;
    TDEAction* m_removePage;
    TDEAction* m_renamePage;
    TDEAction* m_hidePage;
    TDEAction* m_showPage;
    TDEAction* m_arrowHeadsMenuAction;
    TDEAction* m_menuTextFormatAction;
    TDEAction* m_menuStencilConnectorsAction;

    TTDESelectColorAction *m_setFGColor;
    TTDESelectColorAction *m_setBGColor;

    TDEFontAction *m_setFontFamily;
    TDEFontSizeAction *m_setFontSize;
    TDEToggleAction *m_setBold;
    TDEToggleAction *m_setItalics;
    TDEToggleAction *m_setUnderline;
    TTDESelectColorAction *m_setTextColor;
    TDEToggleAction* m_textAlignLeft;
    TDEToggleAction* m_textAlignCenter;
    TDEToggleAction* m_textAlignRight;
    TDEToggleAction* m_textVAlignSuper;
    TDEToggleAction* m_textVAlignSub;

    KivioArrowHeadAction* m_setArrowHeads;

    TQStringList m_lineWidthList;

    KivioDoc* m_pDoc;
    KivioPage* m_pActivePage;
    KivioStencilSpawnerSet* m_pActiveSpawnerSet;

    StencilBarDockManager* m_pStencilBarDockManager;
    KoPaletteManager* m_pPaletteManager;

    KoRuler* vRuler;
    KoRuler* hRuler;

    KivioStencilGeometryPanel* m_pStencilGeometryPanel;
    KivioLayerPanel* m_pLayersPanel;
    KivioBirdEyePanel* m_pBirdEyePanel;
    KivioProtectionPanel* m_pProtectionPanel;
    Kivio::ObjectListPalette* m_objectListPalette;
    TDEToggleAction* showPageMargins;
    TDEToggleAction* showRulers;
    TDEToggleAction* showGrid;
    TDEToggleAction* showGuides;
    TDEAction *m_selectAll;
    TDEAction *m_selectNone;
    TDEAction *m_editCopy;
    TDEAction* m_editCut;
    TDEAction* m_editPaste;
    TDEAction* m_editDelete;
    bool m_bShowPageMargins;
    bool m_bShowRulers;
    bool m_bSnapGuides;
    bool m_bShowGuides;

    DCOPObject *dcop;

    KoZoomHandler* m_zoomHandler;

    KStatusBarLabel* m_coordSLbl;
    KStatusBarLabel* m_pageCountSLbl;
    KStatusBarLabel* m_infoSLbl;

    Kivio::PluginManager* m_pluginManager;

    TDEAction* m_groupAction;
    TDEAction* m_ungroupAction;
    TDEAction* m_stencilToFront;
    TDEAction* m_stencilToBack;
    TDEAction* m_alignAndDistribute;
    KoLineWidthAction* m_lineWidthAction;
    KoLineStyleAction* m_lineStyleAction;

    TQProgressBar* m_statusBarProgress;

    TQScrollBar* m_vertScrollBar;
    TQScrollBar* m_horzScrollBar;
    Kivio::AddStencilTool* m_addStencilTool;

    Kivio::AddStencilSetDialog* m_addStencilSetDialog;
};

#endif
