/* This file is part of the TDE project

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

/*
  This file handles the different version of include files required
  when using libwpd-0.8, libwpd-0.9 or libwpd-0.10
*/

#ifndef __SHARED_HEADERS_H__
#define __SHARED_HEADERS_H__

#include <config.h>

#ifdef HAVE_LIBWPD_0100
  //libwpd-0.10
  #include <librevenge/RVNGBinaryData.h>
  #include <librevenge-stream/librevenge-stream.h>
  #include <librevenge/RVNGPropertyList.h>
  #include <librevenge/RVNGPropertyListVector.h>
  #include <librevenge/RVNGString.h>

  #define _SH_BinaryData          librevenge::RVNGBinaryData
  #define _SH_DocumentInterface   librevenge::RVNGTextInterface
  #define _SH_InputStream         librevenge::RVNGInputStream
  #define _SH_PropertyList        librevenge::RVNGPropertyList
  #define _SH_PropertyListVector  librevenge::RVNGPropertyListVector
  #define _SH_SEEK_CUR            librevenge::RVNG_SEEK_CUR
  #define _SH_SEEK_SET            librevenge::RVNG_SEEK_SET
  #define _SH_SEEK_TYPE           librevenge::RVNG_SEEK_TYPE
  #define _SH_String              librevenge::RVNGString
  
#else
  //libwpd-0.9 and libwpd-0.8
  #include <libwpd/WPXPropertyList.h>
  #include <libwpd/WPXPropertyListVector.h>
  #include <libwpd/WPXString.h>

#ifdef HAVE_LIBWPD_090
  #include <libwpd/WPXBinaryData.h>
  #include <libwpd-stream/libwpd-stream.h>
#else
  #include <libwpd/WPXStream.h>
#endif

  #define _SH_BinaryData          WPXBinaryData
#ifdef HAVE_LIBWPD_090
  #define _SH_DocumentInterface   WPXDocumentInterface
#else
  #define _SH_DocumentInterface   WPXHLListenerImpl
#endif
  #define _SH_InputStream         WPXInputStream
  #define _SH_PropertyList        WPXPropertyList
  #define _SH_PropertyListVector  WPXPropertyListVector
  #define _SH_SEEK_CUR            WPX_SEEK_CUR
  #define _SH_SEEK_SET            WPX_SEEK_SET
  #define _SH_SEEK_TYPE           WPX_SEEK_TYPE
  #define _SH_String              WPXString
#endif

#endif
