/*
 * This file is part of Chalk
 *
 * Copyright (c) 2005-2006 Cyrille Berger <cberger@cberger.net>
 * Copyright (c) 2007 Benjamin Schleimer <bensch128@yahoo.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "kis_dlg_filtersgallery.h"

#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqdatetime.h>

#include <kis_filter.h>
#include <kis_filter_config_widget.h>
#include <kis_filters_listview.h>
#include <kis_paint_device.h>
#include <kis_paint_layer.h>
#include <kis_previewwidget.h>
#include <kis_transaction.h>
#include <kis_types.h>
#include <kis_view.h>

#include "kis_wdg_filtersgallery.h"

namespace Chalk {
namespace Plugins {
namespace FiltersGallery {


KisDlgFiltersGallery::KisDlgFiltersGallery(KisView* view, TQWidget* parent,const char *name)
  : KDialogBase(parent,name, true,i18n("Filters Gallery"), Ok | Cancel), m_view(view),m_currentConfigWidget(0), m_currentFilter(0)
{
   // Initialize main widget
    m_widget = new KisWdgFiltersGallery(this);
    m_widget->filtersList->setLayer(view->canvasSubject()->currentImg()->activeLayer());
    m_widget->filtersList->setProfile(view->canvasSubject()->monitorProfile());
    
    setMainWidget(m_widget);
    // Initialize filters list
    connect(m_widget->filtersList , TQ_SIGNAL(selectionChanged(TQIconViewItem*)), this, TQ_SLOT(selectionHasChanged(TQIconViewItem* )));
    // Initialize configWidgetHolder
    m_widget->configWidgetHolder->setColumnLayout ( 0, TQt::Horizontal );
    //m_widget->configWidgetHolder->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Minimum);
    // Initialize preview widget
    
    if (m_view->canvasSubject()->currentImg() && m_view->canvasSubject()->currentImg()->activeDevice())
    {
        m_widget->previewWidget->slotSetDevice( m_view->canvasSubject()->currentImg()->activeDevice().data() );
    }
    connect( m_widget->previewWidget, TQ_SIGNAL(updated()), this, TQ_SLOT(refreshPreview()));
    resize( minimumSizeHint());
    m_widget->previewWidget->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::MinimumExpanding);
    m_labelNoCW = new TQLabel(i18n("No configuration options are available for this filter."), m_widget->configWidgetHolder);
    m_widget->configWidgetHolder->layout()->add(m_labelNoCW);
    m_labelNoCW->hide();
}

KisDlgFiltersGallery::~KisDlgFiltersGallery()
{
}

void KisDlgFiltersGallery::selectionHasChanged ( TQIconViewItem * item )
{
    KisFiltersIconViewItem* kisitem = (KisFiltersIconViewItem*) item;
    m_currentFilter = kisitem->filter();
    if(m_currentConfigWidget != 0)
    {
        m_widget->configWidgetHolder->layout()->remove(m_currentConfigWidget);
        delete m_currentConfigWidget;
        m_currentConfigWidget = 0;
    } else {
        m_labelNoCW->hide();
    }
    KisImageSP img = m_view->canvasSubject()->currentImg();
    KisPaintLayerSP activeLayer = dynamic_cast<KisPaintLayer*>(img->activeLayer().data());
    
    if (activeLayer)
       m_currentConfigWidget = m_currentFilter->createConfigurationWidget(m_widget->configWidgetHolder, activeLayer->paintDevice());
    
    if(m_currentConfigWidget != 0) {
        //m_currentConfigWidget->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
        m_widget->configWidgetHolder->layout()->add(m_currentConfigWidget);
        m_currentConfigWidget->show();
        connect(m_currentConfigWidget, TQ_SIGNAL(sigPleaseUpdatePreview()), this, TQ_SLOT(slotConfigChanged()));
    }
    else {
        m_labelNoCW->show();
    }
    
    refreshPreview();
}

void KisDlgFiltersGallery::slotConfigChanged()
{
    if(m_widget->previewWidget->getAutoUpdate())
    {
        refreshPreview();
    } else {
        m_widget->previewWidget->needUpdate();
    }
}


void KisDlgFiltersGallery::refreshPreview( )
{
    if(!m_currentFilter) return;

    KisFilterConfiguration* config = m_currentFilter->configuration(m_currentConfigWidget);

    m_widget->previewWidget->runFilter(m_currentFilter, config);
}

}
}
}

#include "kis_dlg_filtersgallery.moc"
