/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_Z3950CONNECTION_H
#define TELLICO_FETCH_Z3950CONNECTION_H

#include <tqthread.h>
#include <tqevent.h>
#include <tqdeepcopy.h>

#include <ksharedptr.h>

namespace Tellico {
  namespace Fetch {
    class Z3950Fetcher;

class Z3950ResultFound : public TQCustomEvent {
public:
  Z3950ResultFound(const TQString& s);
  ~Z3950ResultFound();
  const TQString& result() const { return m_result; }

  static int uid() { return User + 11111; }

private:
  TQString m_result;
};

class Z3950ConnectionDone : public TQCustomEvent {
public:
  Z3950ConnectionDone(bool more) : TQCustomEvent(uid()), m_type(-1), m_hasMore(more) {}
  Z3950ConnectionDone(bool more, const TQString& s, int t) : TQCustomEvent(uid()), m_msg(TQDeepCopy<TQString>(s)), m_type(t), m_hasMore(more) {}

  const TQString& message() const { return m_msg; }
  int messageType() const { return m_type; }
  bool hasMoreResults() const { return m_hasMore; }

  static int uid() { return User + 22222; }

private:
  TQString m_msg;
  int m_type;
  bool m_hasMore;
};

class Z3950SyntaxChange : public TQCustomEvent {
public:
  Z3950SyntaxChange(const TQString& s) : TQCustomEvent(uid()), m_syntax(TQDeepCopy<TQString>(s)) {}
  const TQString& syntax() const { return m_syntax; }

  static int uid() { return User + 33333; }

private:
  TQString m_syntax;
};

/**
 * @author Robby Stephenson
 */
class Z3950Connection : public TQThread {
public:
  Z3950Connection(Z3950Fetcher* fetcher,
                  const TQString& host,
                  uint port,
                  const TQString& dbname,
                  const TQString& sourceCharSet,
                  const TQString& syntax,
                  const TQString& esn);
  ~Z3950Connection();

  void reset();
  void setQuery(const TQString& query);
  void setUserPassword(const TQString& user, const TQString& pword);
  void run();

  void abort() { m_aborted = true; }

private:
  static TQCString iconvRun(const TQCString& text, const TQString& fromCharSet, const TQString& toCharSet);
  static TQString toXML(const TQCString& marc, const TQString& fromCharSet);

  bool makeConnection();
  void done();
  void done(const TQString& message, int type);
  TQCString toCString(const TQString& text);
  TQString toString(const TQCString& text);
  void checkPendingEvents();

  class Private;
  Private* d;

  bool m_connected;
  bool m_aborted;

  TDESharedPtr<Z3950Fetcher> m_fetcher;
  TQString m_host;
  uint m_port;
  TQString m_dbname;
  TQString m_user;
  TQString m_password;
  TQString m_sourceCharSet;
  TQString m_syntax;
  TQString m_pqn;
  TQString m_esn;
  size_t m_start;
  size_t m_limit;
  bool m_hasMore;

  friend class Z3950ResultFound;
  static int resultsLeft;
};

  } // end namespace
} // end namespace

#endif
